/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.cache;

import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.cache.CacheInputFile;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public final class CacheFileSystem
implements TrinoFileSystem {
    private final TrinoFileSystem delegate;
    private final TrinoFileSystemCache cache;
    private final CacheKeyProvider keyProvider;

    public CacheFileSystem(TrinoFileSystem delegate, TrinoFileSystemCache cache, CacheKeyProvider keyProvider) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cache = Objects.requireNonNull(cache, "cache is null");
        this.keyProvider = Objects.requireNonNull(keyProvider, "keyProvider is null");
    }

    @Override
    public TrinoInputFile newInputFile(Location location) {
        return new CacheInputFile(this.delegate.newInputFile(location), this.cache, this.keyProvider, OptionalLong.empty(), Optional.empty());
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length) {
        return new CacheInputFile(this.delegate.newInputFile(location, length), this.cache, this.keyProvider, OptionalLong.of(length), Optional.empty());
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length, Instant lastModified) {
        return new CacheInputFile(this.delegate.newInputFile(location, length, lastModified), this.cache, this.keyProvider, OptionalLong.of(length), Optional.of(lastModified));
    }

    @Override
    public TrinoOutputFile newOutputFile(Location location) {
        TrinoOutputFile output = this.delegate.newOutputFile(location);
        try {
            this.cache.expire(location);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output;
    }

    @Override
    public void deleteFile(Location location) throws IOException {
        this.delegate.deleteFile(location);
        this.cache.expire(location);
    }

    @Override
    public void deleteDirectory(Location location) throws IOException {
        this.delegate.deleteDirectory(location);
        this.cache.expire(location);
    }

    @Override
    public void renameFile(Location source, Location target) throws IOException {
        this.delegate.renameFile(source, target);
        this.cache.expire(source);
        this.cache.expire(target);
    }

    @Override
    public FileIterator listFiles(Location location) throws IOException {
        return this.delegate.listFiles(location);
    }

    @Override
    public Optional<Boolean> directoryExists(Location location) throws IOException {
        return this.delegate.directoryExists(location);
    }

    @Override
    public void createDirectory(Location location) throws IOException {
        this.delegate.createDirectory(location);
    }

    @Override
    public void renameDirectory(Location source, Location target) throws IOException {
        this.delegate.renameDirectory(source, target);
    }

    @Override
    public Set<Location> listDirectories(Location location) throws IOException {
        return this.delegate.listDirectories(location);
    }

    @Override
    public Optional<Location> createTemporaryDirectory(Location targetPath, String temporaryPrefix, String relativePrefix) throws IOException {
        return this.delegate.createTemporaryDirectory(targetPath, temporaryPrefix, relativePrefix);
    }

    @Override
    public void deleteFiles(Collection<Location> locations) throws IOException {
        this.delegate.deleteFiles(locations);
        this.cache.expire(locations);
    }
}

