/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;

@JsonTypeName(value="PrincipalListResponse")
public class PrincipalListResponse {
    private final List<PrincipalInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public PrincipalListResponse(@JsonProperty(value="items") List<PrincipalInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<PrincipalInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalListResponse principalListResponse = (PrincipalListResponse)o;
        return Objects.equals(this.items, principalListResponse.items) && Objects.equals(this.nextPageToken, principalListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "PrincipalListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<PrincipalInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<PrincipalInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public PrincipalListResponse build() {
            return new PrincipalListResponse(this.items, this.nextPageToken);
        }
    }
}

