/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonTypeName(value="PrincipalInfo")
public class PrincipalInfo {
    private final String principalName;
    private final String principalType;
    private final Boolean active;
    private final Set<String> roleNames;
    private final Map<String, String> properties;

    @JsonCreator
    public PrincipalInfo(@JsonProperty(value="principal-name") String principalName, @JsonProperty(value="principal-type") String principalType, @JsonProperty(value="active") Boolean active, @JsonProperty(value="role-names") Set<String> roleNames, @JsonProperty(value="properties") Map<String, String> properties) {
        this.principalName = principalName;
        this.principalType = principalType;
        this.active = active;
        this.roleNames = roleNames;
        this.properties = properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="principal-name")
    public String getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="principal-type")
    public String getPrincipalType() {
        return this.principalType;
    }

    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="role-names")
    public Set<String> getRoleNames() {
        return this.roleNames;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalInfo principalInfo = (PrincipalInfo)o;
        return Objects.equals(this.principalName, principalInfo.principalName) && Objects.equals(this.principalType, principalInfo.principalType) && Objects.equals(this.active, principalInfo.active) && Objects.equals(this.roleNames, principalInfo.roleNames) && Objects.equals(this.properties, principalInfo.properties);
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.principalType, this.active, this.roleNames, this.properties);
    }

    public String toString() {
        return "PrincipalInfo{principalName='" + this.principalName + "', principalType='" + this.principalType + "', active='" + this.active + "', roleNames='" + String.valueOf(this.roleNames) + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    public static class Builder {
        private String principalName;
        private String principalType;
        private Boolean active;
        private Set<String> roleNames;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder setPrincipalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder setPrincipalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder setRoleNames(Set<String> roleNames) {
            this.roleNames = roleNames;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public PrincipalInfo build() {
            return new PrincipalInfo(this.principalName, this.principalType, this.active, this.roleNames, this.properties);
        }
    }
}

