/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="IcebergObjectInfo")
public class IcebergObjectInfo {
    private final String catalogName;
    private final String namespaceName;
    private final String objectName;
    private final String objectType;
    private final String metadataLocation;
    private final String previousMetadataLocation;

    @JsonCreator
    public IcebergObjectInfo(@JsonProperty(value="catalog-name") String catalogName, @JsonProperty(value="namespace-name") String namespaceName, @JsonProperty(value="object-name") String objectName, @JsonProperty(value="object-type") String objectType, @JsonProperty(value="metadata-location") String metadataLocation, @JsonProperty(value="previous-metadata-location") String previousMetadataLocation) {
        this.catalogName = catalogName;
        this.namespaceName = namespaceName;
        this.objectName = objectName;
        this.objectType = objectType;
        this.metadataLocation = metadataLocation;
        this.previousMetadataLocation = previousMetadataLocation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="catalog-name")
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="namespace-name")
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @JsonProperty(value="object-name")
    public String getObjectName() {
        return this.objectName;
    }

    @JsonProperty(value="object-type")
    public String getObjectType() {
        return this.objectType;
    }

    @JsonProperty(value="metadata-location")
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    @JsonProperty(value="previous-metadata-location")
    public String getPreviousMetadataLocation() {
        return this.previousMetadataLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergObjectInfo icebergObjectInfo = (IcebergObjectInfo)o;
        return Objects.equals(this.catalogName, icebergObjectInfo.catalogName) && Objects.equals(this.namespaceName, icebergObjectInfo.namespaceName) && Objects.equals(this.objectName, icebergObjectInfo.objectName) && Objects.equals(this.objectType, icebergObjectInfo.objectType) && Objects.equals(this.metadataLocation, icebergObjectInfo.metadataLocation) && Objects.equals(this.previousMetadataLocation, icebergObjectInfo.previousMetadataLocation);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.namespaceName, this.objectName, this.objectType, this.metadataLocation, this.previousMetadataLocation);
    }

    public String toString() {
        return "IcebergObjectInfo{catalogName='" + this.catalogName + "', namespaceName='" + this.namespaceName + "', objectName='" + this.objectName + "', objectType='" + this.objectType + "', metadataLocation='" + this.metadataLocation + "', previousMetadataLocation='" + this.previousMetadataLocation + "'}";
    }

    public static class Builder {
        private String catalogName;
        private String namespaceName;
        private String objectName;
        private String objectType;
        private String metadataLocation;
        private String previousMetadataLocation;

        private Builder() {
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder setObjectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder setObjectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        public Builder setPreviousMetadataLocation(String previousMetadataLocation) {
            this.previousMetadataLocation = previousMetadataLocation;
            return this;
        }

        public IcebergObjectInfo build() {
            return new IcebergObjectInfo(this.catalogName, this.namespaceName, this.objectName, this.objectType, this.metadataLocation, this.previousMetadataLocation);
        }
    }
}

