/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="FileSystemCheckRequest")
public class FileSystemCheckRequest {
    private final String fileSystemName;
    private final String location;

    @JsonCreator
    public FileSystemCheckRequest(@JsonProperty(value="file-system-name") String fileSystemName, @JsonProperty(value="location") String location) {
        this.fileSystemName = fileSystemName;
        this.location = location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="file-system-name")
    public String getFileSystemName() {
        return this.fileSystemName;
    }

    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemCheckRequest fileSystemCheckRequest = (FileSystemCheckRequest)o;
        return Objects.equals(this.fileSystemName, fileSystemCheckRequest.fileSystemName) && Objects.equals(this.location, fileSystemCheckRequest.location);
    }

    public int hashCode() {
        return Objects.hash(this.fileSystemName, this.location);
    }

    public String toString() {
        return "FileSystemCheckRequest{fileSystemName='" + this.fileSystemName + "', location='" + this.location + "'}";
    }

    public static class Builder {
        private String fileSystemName;
        private String location;

        private Builder() {
        }

        public Builder setFileSystemName(String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FileSystemCheckRequest build() {
            return new FileSystemCheckRequest(this.fileSystemName, this.location);
        }
    }
}

