/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.AccessTokenInfo;

@JsonTypeName(value="AccessTokenListResponse")
public class AccessTokenListResponse {
    private final List<AccessTokenInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public AccessTokenListResponse(@JsonProperty(value="items") List<AccessTokenInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<AccessTokenInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessTokenListResponse accessTokenListResponse = (AccessTokenListResponse)o;
        return Objects.equals(this.items, accessTokenListResponse.items) && Objects.equals(this.nextPageToken, accessTokenListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "AccessTokenListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<AccessTokenInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<AccessTokenInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public AccessTokenListResponse build() {
            return new AccessTokenListResponse(this.items, this.nextPageToken);
        }
    }
}

