/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="AccessTokenInfo")
public class AccessTokenInfo {
    private final String accessTokenId;
    private final String principalName;
    private final String description;

    @JsonCreator
    public AccessTokenInfo(@JsonProperty(value="access-token-id") String accessTokenId, @JsonProperty(value="principal-name") String principalName, @JsonProperty(value="description") String description) {
        this.accessTokenId = accessTokenId;
        this.principalName = principalName;
        this.description = description;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="access-token-id")
    public String getAccessTokenId() {
        return this.accessTokenId;
    }

    @JsonProperty(value="principal-name")
    public String getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessTokenInfo accessTokenInfo = (AccessTokenInfo)o;
        return Objects.equals(this.accessTokenId, accessTokenInfo.accessTokenId) && Objects.equals(this.principalName, accessTokenInfo.principalName) && Objects.equals(this.description, accessTokenInfo.description);
    }

    public int hashCode() {
        return Objects.hash(this.accessTokenId, this.principalName, this.description);
    }

    public String toString() {
        return "AccessTokenInfo{accessTokenId='" + this.accessTokenId + "', principalName='" + this.principalName + "', description='" + this.description + "'}";
    }

    public static class Builder {
        private String accessTokenId;
        private String principalName;
        private String description;

        private Builder() {
        }

        public Builder setAccessTokenId(String accessTokenId) {
            this.accessTokenId = accessTokenId;
            return this;
        }

        public Builder setPrincipalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public AccessTokenInfo build() {
            return new AccessTokenInfo(this.accessTokenId, this.principalName, this.description);
        }
    }
}

