/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.Map;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;

public class CatalogRoleNotGrantedException
extends CatalogException {
    public static final String PROPERTY_PRINCIPAL_NAME = "principal-name";
    public static final String PROPERTY_ROLE_NAME = "role-name";

    public CatalogRoleNotGrantedException(String principalName, String roleName) {
        super(CatalogErrorCode.ROLE_NOT_GRANTED, String.format("Role \"%s\" is not granted to principal \"%s\"", roleName, principalName), Map.of(PROPERTY_PRINCIPAL_NAME, principalName, PROPERTY_ROLE_NAME, roleName));
    }

    public CatalogRoleNotGrantedException(String message, Map<String, String> details) {
        super(CatalogErrorCode.ROLE_NOT_GRANTED, message, details);
    }
}

