/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;

public abstract class CatalogException
extends RuntimeException {
    private final CatalogErrorCode errorCode;
    private final Map<String, String> details;

    protected CatalogException(CatalogErrorCode errorCode, String message) {
        this(errorCode, message, Collections.emptyMap());
    }

    protected CatalogException(CatalogErrorCode errorCode, String message, Map<String, String> details) {
        super(message);
        this.errorCode = errorCode;
        this.details = CatalogException.normalizeDetails(details);
    }

    protected CatalogException(CatalogErrorCode errorCode, Throwable cause) {
        this(errorCode, cause, Collections.emptyMap());
    }

    protected CatalogException(CatalogErrorCode errorCode, Throwable cause, Map<String, String> details) {
        super(cause);
        this.errorCode = errorCode;
        this.details = CatalogException.normalizeDetails(details);
    }

    protected CatalogException(CatalogErrorCode errorCode, String message, Throwable cause) {
        this(errorCode, message, cause, Collections.emptyMap());
    }

    protected CatalogException(CatalogErrorCode errorCode, String message, Throwable cause, Map<String, String> details) {
        super(message, cause);
        this.errorCode = errorCode;
        this.details = CatalogException.normalizeDetails(details);
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return this.errorCode.getCodeCaption() + ": " + super.getMessage();
    }

    public CatalogErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    private static Map<String, String> normalizeDetails(Map<String, String> details) {
        if (details == null || details.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(new TreeMap<String, String>(details)));
    }
}

