/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.HashMap;
import java.util.Map;

public enum CatalogErrorCodeGroup {
    GENERIC(1),
    PRINCIPAL(2),
    FILE_SYSTEM(3),
    ICEBERG_CATALOG(4),
    ICEBERG_NAMESPACE(101),
    ICEBERG_OBJECT(102);

    private static final Map<Integer, CatalogErrorCodeGroup> CODE_MAP;
    private final int code;

    private CatalogErrorCodeGroup(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    static {
        CODE_MAP = new HashMap<Integer, CatalogErrorCodeGroup>();
        for (CatalogErrorCodeGroup code : CatalogErrorCodeGroup.values()) {
            CatalogErrorCodeGroup previousCode = CODE_MAP.put(code.code, code);
            if (previousCode == null) continue;
            throw new IllegalStateException("Conflicting error group code: " + String.valueOf((Object)code) + ", " + String.valueOf((Object)previousCode));
        }
    }
}

