/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCodeGroup;

public enum CatalogErrorCode {
    GENERIC_ERROR(CatalogErrorCodeGroup.GENERIC, 1),
    INTERNAL_SERVER_ERROR(CatalogErrorCodeGroup.GENERIC, 2),
    BAD_REQUEST(CatalogErrorCodeGroup.GENERIC, 3),
    AUTHENTICATION_ERROR(CatalogErrorCodeGroup.GENERIC, 4),
    AUTHORIZATION_ERROR(CatalogErrorCodeGroup.GENERIC, 5),
    UNSUPPORTED_OPERATION(CatalogErrorCodeGroup.GENERIC, 6),
    UNPROCESSABLE_ENTITY(CatalogErrorCodeGroup.GENERIC, 7),
    CLIENT_ERROR(CatalogErrorCodeGroup.GENERIC, 8),
    SERVICE_UNAVAILABLE(CatalogErrorCodeGroup.GENERIC, 9),
    PRINCIPAL_DOESNT_EXIST(CatalogErrorCodeGroup.PRINCIPAL, 1),
    PRINCIPAL_ALREADY_EXISTS(CatalogErrorCodeGroup.PRINCIPAL, 2),
    ACCESS_TOKEN_DOESNT_EXIST(CatalogErrorCodeGroup.PRINCIPAL, 3),
    ROLE_DOESNT_EXIST(CatalogErrorCodeGroup.PRINCIPAL, 4),
    ROLE_ALREADY_GRANTED(CatalogErrorCodeGroup.PRINCIPAL, 5),
    ROLE_NOT_GRANTED(CatalogErrorCodeGroup.PRINCIPAL, 6),
    RECURSIVE_ROLE_GRANT(CatalogErrorCodeGroup.PRINCIPAL, 7),
    PRINCIPAL_IN_USE_EXCEPTION(CatalogErrorCodeGroup.PRINCIPAL, 8),
    FILE_SYSTEM_DOESNT_EXIST(CatalogErrorCodeGroup.FILE_SYSTEM, 1),
    FILE_SYSTEM_ALREADY_EXISTS(CatalogErrorCodeGroup.FILE_SYSTEM, 2),
    FILE_SYSTEM_IN_USE(CatalogErrorCodeGroup.FILE_SYSTEM, 3),
    FILE_SYSTEM_STOPPING(CatalogErrorCodeGroup.FILE_SYSTEM, 4),
    ICEBERG_CATALOG_DOESNT_EXIST(CatalogErrorCodeGroup.ICEBERG_CATALOG, 1),
    ICEBERG_CATALOG_ALREADY_EXISTS(CatalogErrorCodeGroup.ICEBERG_CATALOG, 2),
    ICEBERG_CATALOG_IN_USE(CatalogErrorCodeGroup.ICEBERG_CATALOG, 3),
    ICEBERG_NAMESPACE_DOESNT_EXIST(CatalogErrorCodeGroup.ICEBERG_NAMESPACE, 1),
    ICEBERG_NAMESPACE_ALREADY_EXISTS(CatalogErrorCodeGroup.ICEBERG_NAMESPACE, 2),
    ICEBERG_NAMESPACE_NOT_EMPTY(CatalogErrorCodeGroup.ICEBERG_NAMESPACE, 3),
    ICEBERG_OBJECT_DOESNT_EXIST(CatalogErrorCodeGroup.ICEBERG_OBJECT, 1),
    ICEBERG_OBJECT_ALREADY_EXISTS(CatalogErrorCodeGroup.ICEBERG_OBJECT, 2),
    ICEBERG_OBJECT_COMMIT_FAILED(CatalogErrorCodeGroup.ICEBERG_OBJECT, 3);

    private static final Map<Integer, CatalogErrorCode> CODE_MAP;
    private final CatalogErrorCodeGroup group;
    private final int code;

    private CatalogErrorCode(CatalogErrorCodeGroup group, int code) {
        this.group = group;
        this.code = group.getCode() * 1000 + code;
    }

    public CatalogErrorCodeGroup getGroup() {
        return this.group;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeCaption() {
        return String.format("CCE-%08d", this.code);
    }

    public String toString() {
        return this.getCodeCaption();
    }

    public static CatalogErrorCode fromCode(int code) {
        Optional<CatalogErrorCode> res = CatalogErrorCode.fromCodeOrEmpty(code);
        if (res.isEmpty()) {
            throw new IllegalArgumentException("Unknown error code: " + code);
        }
        return res.get();
    }

    public static Optional<CatalogErrorCode> fromCodeOrEmpty(int code) {
        return Optional.ofNullable(CODE_MAP.get(code));
    }

    static {
        CODE_MAP = new HashMap<Integer, CatalogErrorCode>();
        for (CatalogErrorCode code : CatalogErrorCode.values()) {
            CatalogErrorCode previousCode = CODE_MAP.put(code.code, code);
            if (previousCode == null) continue;
            throw new IllegalStateException("Conflicting error codes: " + String.valueOf((Object)code) + ", " + String.valueOf((Object)previousCode));
        }
    }
}

