/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.Map;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;
import ru.cedrusdata.catalog.spi.security.CatalogPrivilege;

public class CatalogAuthorizationException
extends CatalogException {
    public static final String PROPERTY_PRIVILEGE_NAME = "privilege-name";

    public CatalogAuthorizationException(CatalogPrivilege privilege) {
        this(privilege.getCaption());
    }

    public CatalogAuthorizationException(String privilegeName) {
        super(CatalogErrorCode.AUTHORIZATION_ERROR, String.format("Insufficient privilege \"%s\"", privilegeName), Map.of(PROPERTY_PRIVILEGE_NAME, privilegeName));
    }

    public CatalogAuthorizationException(String message, Map<String, String> details) {
        super(CatalogErrorCode.AUTHORIZATION_ERROR, message, details);
    }
}

