/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;

public class CatalogPrincipalClient {
    private final InternalCatalogClient delegate;

    public CatalogPrincipalClient(InternalCatalogClient delegate) {
        this.delegate = delegate;
    }

    public void createPrincipal(PrincipalCreateRequest request) {
        this.delegate.createPrincipal(request);
    }

    public void updatePrincipal(String principalName, PrincipalUpdateRequest request) {
        this.delegate.updatePrincipal(principalName, request);
    }

    public void deletePrincipal(String principalName) {
        this.delegate.deletePrincipal(principalName);
    }

    public PrincipalInfo getPrincipal(String principalName) {
        return this.delegate.getPrincipal(principalName);
    }

    public PrincipalListResponse listPrincipals(Optional<String> principalType, ResultPage page) {
        return this.delegate.listPrincipals(principalType, page);
    }

    public List<PrincipalInfo> listAllPrincipals(Optional<String> principalType) {
        PrincipalListResponse response;
        ArrayList<PrincipalInfo> res = new ArrayList<PrincipalInfo>();
        String nextPageToken = null;
        do {
            response = this.listPrincipals(principalType, new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }
}

