/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;

public class CatalogIcebergClient {
    private final InternalCatalogClient delegate;

    public CatalogIcebergClient(InternalCatalogClient delegate) {
        this.delegate = delegate;
    }

    public void createCatalog(IcebergCatalogCreateRequest request) {
        this.delegate.createIcebergCatalog(request);
    }

    public void updateCatalog(String icebergCatalogName, IcebergCatalogUpdateRequest request) {
        this.delegate.updateIcebergCatalog(icebergCatalogName, request);
    }

    public void deleteCatalog(String icebergCatalogName) {
        this.delegate.deleteIcebergCatalog(icebergCatalogName);
    }

    public IcebergCatalogInfo getCatalog(String icebergCatalogName) {
        return this.delegate.getIcebergCatalog(icebergCatalogName);
    }

    public IcebergCatalogListResponse listCatalogs(ResultPage page) {
        return this.delegate.listIcebergCatalogs(page);
    }

    public List<IcebergCatalogInfo> listAllCatalogs() {
        IcebergCatalogListResponse response;
        ArrayList<IcebergCatalogInfo> res = new ArrayList<IcebergCatalogInfo>();
        String nextPageToken = null;
        do {
            response = this.listCatalogs(new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }

    public IcebergNamespaceInfo getNamespace(String catalogName, String namespaceName) {
        return this.delegate.getIcebergNamespace(catalogName, namespaceName);
    }

    public IcebergNamespaceListResponse listNamespaces(Optional<String> catalogName, ResultPage page) {
        return this.delegate.listIcebergNamespaces(catalogName, page);
    }

    public List<IcebergNamespaceInfo> listAllNamespaces(Optional<String> catalogName) {
        IcebergNamespaceListResponse response;
        ArrayList<IcebergNamespaceInfo> res = new ArrayList<IcebergNamespaceInfo>();
        String nextPageToken = null;
        do {
            response = this.listNamespaces(catalogName, new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }

    public IcebergObjectInfo getObject(String catalogName, String namespaceName, String objectName) {
        return this.delegate.getIcebergObject(catalogName, namespaceName, objectName);
    }

    public IcebergObjectListResponse listObjects(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        return this.delegate.listIcebergObjects(catalogName, namespaceName, objectType, page);
    }

    public List<IcebergObjectInfo> listAllObjects(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType) {
        IcebergObjectListResponse response;
        ArrayList<IcebergObjectInfo> res = new ArrayList<IcebergObjectInfo>();
        String nextPageToken = null;
        do {
            response = this.listObjects(catalogName, namespaceName, objectType, new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(String catalogName, IcebergMaterializedViewForRewriteListRequest request) {
        return this.delegate.listMaterializedViewsForRewrite(catalogName, request);
    }
}

