/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;

public class CatalogFileSystemClient {
    private final InternalCatalogClient delegate;

    public CatalogFileSystemClient(InternalCatalogClient delegate) {
        this.delegate = delegate;
    }

    public void createFileSystem(FileSystemCreateRequest request) {
        this.delegate.createFileSystem(request);
    }

    public void updateFileSystem(String fileSystemName, FileSystemUpdateRequest request) {
        this.delegate.updateFileSystem(fileSystemName, request);
    }

    public void deleteFileSystem(String fileSystemName) {
        this.delegate.deleteFileSystem(fileSystemName);
    }

    public FileSystemCheckResponse checkFileSystem(FileSystemCheckRequest request) {
        return this.delegate.checkFileSystem(request);
    }

    public FileSystemInfo getFileSystem(String fileSystemName) {
        return this.delegate.getFileSystem(fileSystemName);
    }

    public FileSystemListResponse listFileSystems(ResultPage page) {
        return this.delegate.listFileSystems(page);
    }

    public List<FileSystemInfo> listAllFileSystems() {
        FileSystemListResponse response;
        ArrayList<FileSystemInfo> res = new ArrayList<FileSystemInfo>();
        String nextPageToken = null;
        do {
            response = this.listFileSystems(new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }
}

