/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenInfo;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;

public class CatalogAccessTokenClient {
    private final InternalCatalogClient delegate;

    public CatalogAccessTokenClient(InternalCatalogClient delegate) {
        this.delegate = delegate;
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken(String subject) {
        return this.delegate.createTemporaryAccessToken(subject);
    }

    public AccessTokenCreateResponse createAccessToken(AccessTokenCreateRequest request) {
        return this.delegate.createAccessToken(request);
    }

    public void deleteAccessToken(String accessTokenId) {
        this.delegate.deleteAccessToken(accessTokenId);
    }

    public AccessTokenListResponse listAccessTokens(Optional<String> principalName, ResultPage resultPage) {
        return this.delegate.listAccessTokens(principalName, resultPage);
    }

    public List<AccessTokenInfo> listAllAccessTokens(Optional<String> principal) {
        AccessTokenListResponse response;
        ArrayList<AccessTokenInfo> res = new ArrayList<AccessTokenInfo>();
        String nextPageToken = null;
        do {
            response = this.listAccessTokens(principal, new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }
}

