/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.Experimental;
import io.trino.spi.function.Signature;
import java.util.Locale;
import java.util.Objects;

@Experimental(eta="2022-10-31")
public class FunctionId {
    private final String id;

    @JsonCreator
    public FunctionId(String id) {
        Objects.requireNonNull(id, "id is null");
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id must not be empty");
        }
        if (!id.toLowerCase(Locale.US).equals(id)) {
            throw new IllegalArgumentException("id must be lowercase");
        }
        if (id.contains("@")) {
            throw new IllegalArgumentException("id must not contain '@'");
        }
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionId that = (FunctionId)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public static FunctionId toFunctionId(String canonicalName, Signature signature) {
        return new FunctionId((canonicalName + String.valueOf(signature)).toLowerCase(Locale.US));
    }
}

