/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Unstable;
import io.trino.spi.eventlistener.RoutineInfo;
import io.trino.spi.eventlistener.TableInfo;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class QueryMetadata {
    private final String queryId;
    private final Optional<String> transactionId;
    private final Optional<String> encoding;
    private final String query;
    private final Optional<String> updateType;
    private final Optional<String> preparedQuery;
    private final String queryState;
    private final URI uri;
    private final List<TableInfo> tables;
    private final List<RoutineInfo> routines;
    private final Optional<String> plan;
    private final Optional<String> jsonPlan;
    private final Supplier<Optional<String>> payloadProvider;

    @JsonCreator
    @Unstable
    public QueryMetadata(String queryId, Optional<String> transactionId, Optional<String> encoding, String query, Optional<String> updateType, Optional<String> preparedQuery, String queryState, List<TableInfo> tables, List<RoutineInfo> routines, URI uri, Optional<String> plan, Optional<String> jsonPlan, Optional<String> payload) {
        this(queryId, transactionId, encoding, query, updateType, preparedQuery, queryState, tables, routines, uri, plan, jsonPlan, () -> payload);
    }

    public QueryMetadata(String queryId, Optional<String> transactionId, Optional<String> encoding, String query, Optional<String> updateType, Optional<String> preparedQuery, String queryState, List<TableInfo> tables, List<RoutineInfo> routines, URI uri, Optional<String> plan, Optional<String> jsonPlan, Supplier<Optional<String>> payloadProvider) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.encoding = Objects.requireNonNull(encoding, "encoding is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.updateType = Objects.requireNonNull(updateType, "updateType is null");
        this.preparedQuery = Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        this.queryState = Objects.requireNonNull(queryState, "queryState is null");
        this.tables = Objects.requireNonNull(tables, "tables is null");
        this.routines = Objects.requireNonNull(routines, "routines is null");
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.jsonPlan = Objects.requireNonNull(jsonPlan, "jsonPlan is null");
        this.payloadProvider = Objects.requireNonNull(payloadProvider, "payloadProvider is null");
    }

    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public Optional<String> getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public Optional<String> getEncoding() {
        return this.encoding;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public Optional<String> getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public Optional<String> getPreparedQuery() {
        return this.preparedQuery;
    }

    @JsonProperty
    public String getQueryState() {
        return this.queryState;
    }

    @JsonProperty
    public List<TableInfo> getTables() {
        return this.tables;
    }

    @JsonProperty
    public List<RoutineInfo> getRoutines() {
        return this.routines;
    }

    @JsonProperty
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty
    public Optional<String> getPlan() {
        return this.plan;
    }

    @JsonProperty
    public Optional<String> getJsonPlan() {
        return this.jsonPlan;
    }

    @JsonProperty
    public Optional<String> getPayload() {
        return this.payloadProvider.get();
    }
}

