/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.s3;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemFactory;
import java.net.URI;
import java.util.Optional;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystemFactory;

public class CatalogS3TrinoFileSystemFactory
extends CatalogTrinoFileSystemFactory {
    private static final String S3_SCHEME = "s3";
    private static final String S3A_SCHEME = "s3a";

    @Inject
    public CatalogS3TrinoFileSystemFactory(S3FileSystemFactory delegate) {
        super((TrinoFileSystemFactory)delegate);
    }

    protected Optional<String> isLocationValid(URI locationUri) {
        if (S3_SCHEME.equalsIgnoreCase(locationUri.getScheme()) || S3A_SCHEME.equalsIgnoreCase(locationUri.getScheme())) {
            return Optional.empty();
        }
        return Optional.of(String.format("File system location \"%s\" has invalid scheme (must be \"%s\")", locationUri, S3_SCHEME));
    }

    public void close() {
        ((S3FileSystemFactory)this.delegate).destroy();
    }
}

