/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.s3;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.trino.filesystem.s3.S3FileSystemConfig;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CatalogS3FileSystemConfig {
    private static final String ENDPOINT = "endpoint";
    private static final String REGION = "region";
    private static final String PATH_STYLE_ACCESS = "path-style-access";
    private static final String ACCESS_KEY = "access-key";
    private static final String SECRET_KEY = "secret-key";
    private static final String STS_ROLE_ARN = "sts-role-arn";
    private static final String STS_ROLE_SESSION_NAME = "sts-role-session-name";
    private static final String STS_EXTERNAL_ID = "sts-external-id";
    private static final String STS_ENDPOINT = "sts-endpoint";
    private static final String STS_REGION = "sts-region";
    private static final String EXCLUSIVE_CREATE = "exclusive-create";
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final String DEFAULT_REGION = "us-east-1";
    private String endpoint;
    private String region;
    private boolean pathStyleAccess;
    private String accessKey;
    private String secretKey;
    private String stsRoleArn;
    private String stsRoleSessionName = "cedrusdata-catalog";
    private String stsExternalId;
    private String stsEndpoint;
    private String stsRegion;
    private boolean exclusiveCreate;

    public String getEndpoint() {
        return this.endpoint;
    }

    @Config(value="endpoint")
    public CatalogS3FileSystemConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    @Config(value="region")
    public CatalogS3FileSystemConfig setRegion(String region) {
        this.region = region;
        return this;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    @Config(value="path-style-access")
    public CatalogS3FileSystemConfig setPathStyleAccess(boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
        return this;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    @Config(value="access-key")
    @ConfigSecuritySensitive
    public CatalogS3FileSystemConfig setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    @Config(value="secret-key")
    @ConfigSecuritySensitive
    public CatalogS3FileSystemConfig setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String getStsRoleArn() {
        return this.stsRoleArn;
    }

    @Config(value="sts-role-arn")
    public CatalogS3FileSystemConfig setStsRoleArn(String stsRoleArn) {
        this.stsRoleArn = stsRoleArn;
        return this;
    }

    public String getStsRoleSessionName() {
        return this.stsRoleSessionName;
    }

    @Config(value="sts-role-session-name")
    public CatalogS3FileSystemConfig setStsRoleSessionName(String stsRoleSessionName) {
        this.stsRoleSessionName = stsRoleSessionName;
        return this;
    }

    public String getStsExternalId() {
        return this.stsExternalId;
    }

    @Config(value="sts-external-id")
    @ConfigSecuritySensitive
    public CatalogS3FileSystemConfig setStsExternalId(String stsExternalId) {
        this.stsExternalId = stsExternalId;
        return this;
    }

    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    @Config(value="sts-endpoint")
    public CatalogS3FileSystemConfig setStsEndpoint(String stsEndpoint) {
        this.stsEndpoint = stsEndpoint;
        return this;
    }

    public String getStsRegion() {
        return this.stsRegion;
    }

    @Config(value="sts-region")
    public CatalogS3FileSystemConfig setStsRegion(String stsRegion) {
        this.stsRegion = stsRegion;
        return this;
    }

    public boolean isExclusiveCreate() {
        return this.exclusiveCreate;
    }

    @Config(value="exclusive-create")
    public CatalogS3FileSystemConfig setExclusiveCreate(boolean exclusiveCreate) {
        this.exclusiveCreate = exclusiveCreate;
        return this;
    }

    public S3FileSystemConfig toTrinoConfig() {
        return new S3FileSystemConfig().setEndpoint(this.endpoint).setRegion(this.region).setPathStyleAccess(this.pathStyleAccess).setAwsAccessKey(this.accessKey).setAwsSecretKey(this.secretKey).setIamRole(this.stsRoleArn).setRoleSessionName(this.stsRoleSessionName).setExternalId(this.stsExternalId).setStsEndpoint(this.stsEndpoint).setStsRegion(this.stsRegion).setSupportsExclusiveCreate(this.exclusiveCreate);
    }

    public static Optional<String> validateProperties(Map<String, String> mutableConfig) {
        Optional<String> error = CatalogS3FileSystemConfig.validateEndpoint(mutableConfig, ENDPOINT, null);
        if (error.isPresent()) {
            return error;
        }
        String endpoint = mutableConfig.get(ENDPOINT);
        mutableConfig.putIfAbsent(REGION, DEFAULT_REGION);
        String pathStyleAccess = mutableConfig.get(PATH_STYLE_ACCESS);
        if (pathStyleAccess == null) {
            mutableConfig.put(PATH_STYLE_ACCESS, "true");
        } else if (!"true".equalsIgnoreCase(pathStyleAccess) && !"false".equalsIgnoreCase(pathStyleAccess)) {
            return Optional.of(String.format("Invalid \"%s\" (should be \"true\" or \"false\": \"%s\"", PATH_STYLE_ACCESS, pathStyleAccess));
        }
        String accessKey = mutableConfig.get(ACCESS_KEY);
        String secretKey = mutableConfig.get(SECRET_KEY);
        if (accessKey != null && secretKey == null) {
            return Optional.of(String.format("\"%s\" must be set when \"%s\" is present", SECRET_KEY, ACCESS_KEY));
        }
        if (secretKey != null && accessKey == null) {
            return Optional.of(String.format("\"%s\" must be set when \"%s\" is present", ACCESS_KEY, SECRET_KEY));
        }
        String stsRoleArn = mutableConfig.get(STS_ROLE_ARN);
        if (stsRoleArn != null) {
            error = CatalogS3FileSystemConfig.validateEndpoint(mutableConfig, STS_ENDPOINT, endpoint);
            if (error.isPresent()) {
                return error;
            }
            if (mutableConfig.get(STS_ENDPOINT) == null) {
                return Optional.of(String.format("\"%s\" or \"%s\"/\"%s\" are required", ENDPOINT, STS_ROLE_ARN, STS_ENDPOINT));
            }
            mutableConfig.putIfAbsent(STS_REGION, mutableConfig.get(REGION));
        } else {
            if (endpoint == null) {
                return Optional.of(String.format("\"%s\" or \"%s\"/\"%s\" are required", ENDPOINT, STS_ROLE_ARN, STS_ENDPOINT));
            }
            if (accessKey == null) {
                return Optional.of(String.format("\"%s\"/\"%s\" or \"%s\" are required", ACCESS_KEY, SECRET_KEY, STS_ROLE_ARN));
            }
        }
        HashMap<String, String> unusedConfig = new HashMap<String, String>(mutableConfig);
        for (Method method : CatalogS3FileSystemConfig.class.getMethods()) {
            Config config = method.getAnnotation(Config.class);
            if (config == null) continue;
            unusedConfig.remove(config.value());
        }
        if (!unusedConfig.isEmpty()) {
            return Optional.of(String.format("Unsupported property: \"%s\"", unusedConfig.keySet().iterator().next()));
        }
        String exclusiveCreate = mutableConfig.get(EXCLUSIVE_CREATE);
        if (exclusiveCreate == null) {
            mutableConfig.put(EXCLUSIVE_CREATE, "true");
        } else if (!"true".equalsIgnoreCase(exclusiveCreate) && !"false".equalsIgnoreCase(exclusiveCreate)) {
            return Optional.of(String.format("Invalid \"%s\" (should be \"true\" or \"false\": \"%s\"", EXCLUSIVE_CREATE, exclusiveCreate));
        }
        return Optional.empty();
    }

    private static Optional<String> validateEndpoint(Map<String, String> mutableConfig, String propertyName, String defaultValue) {
        URI uri;
        String value = mutableConfig.get(propertyName);
        if (value == null) {
            if (defaultValue != null) {
                value = defaultValue;
                mutableConfig.put(propertyName, value);
            }
            return Optional.empty();
        }
        try {
            uri = new URI(value);
        }
        catch (URISyntaxException e) {
            return Optional.of(String.format("Invalid %s syntax: %s", propertyName, e.getMessage()));
        }
        String endpointScheme = uri.getScheme();
        if (!SCHEME_HTTPS.equalsIgnoreCase(endpointScheme) && !SCHEME_HTTP.equalsIgnoreCase(endpointScheme)) {
            return Optional.of(String.format("\"%s\" must start with \"%s://\" or \"%s://\"", propertyName, SCHEME_HTTPS, SCHEME_HTTP));
        }
        return Optional.empty();
    }
}

