/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.hdfs;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.CedrusDataBootstrap;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.base.jmx.MBeanServerModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.weakref.jmx.guice.MBeanModule;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsFileSystemConfig;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsFileSystemJmxObjectNameGeneratorModule;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsFileSystemModule;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsTrinoFileSystemFactory;
import ru.cedrusdata.catalog.spi.CatalogPluginContext;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemFactory;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemProvider;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.jmx.CatalogJmxNameCheck;

public class CatalogHdfsFileSystemProvider
implements CatalogFileSystemProvider {
    public CatalogFileSystemType getFileSystemType() {
        return CatalogFileSystemType.HDFS;
    }

    public CatalogFileSystemFactory createFileSystemFactory(CatalogPluginContext context, String fileSystemName, Map<String, String> config) {
        Optional<String> error = CatalogHdfsFileSystemConfig.validateProperties(config = config != null ? new HashMap<String, String>(config) : new HashMap(), context.resourceResolver());
        if (error.isPresent()) {
            throw (RuntimeException)context.configExceptionProvider().apply("Invalid properties: " + error.get());
        }
        ClassLoader classLoader = CatalogHdfsFileSystemProvider.class.getClassLoader();
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader(classLoader);){
            CedrusDataBootstrap app = new CedrusDataBootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new CatalogHdfsFileSystemJmxObjectNameGeneratorModule(fileSystemName), binder -> {
                binder.bind(CatalogJmxNameCheck.class).toInstance((Object)context.jmxNameCheck());
                binder.bind(OpenTelemetry.class).toInstance((Object)context.fileSystemOpenTelemetry());
            }, new CatalogHdfsFileSystemModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(Map.of()).setOptionalConfigurationProperties(config).quiet().initialize();
            CatalogFileSystemFactory catalogFileSystemFactory = (CatalogFileSystemFactory)injector.getInstance(CatalogHdfsTrinoFileSystemFactory.class);
            return catalogFileSystemFactory;
        }
    }
}

