/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.hdfs;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.authentication.CachingKerberosHadoopAuthentication;
import io.trino.hdfs.authentication.DirectHdfsAuthentication;
import io.trino.hdfs.authentication.ForHdfs;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.ImpersonatingHdfsAuthentication;
import io.trino.hdfs.authentication.KerberosHadoopAuthentication;
import io.trino.plugin.base.authentication.KerberosAuthentication;
import io.trino.plugin.base.authentication.KerberosConfiguration;
import io.trino.plugin.base.security.UserNameProvider;
import ru.cedrusdata.catalog.filesystem.hdfs.CatalogHdfsFileSystemConfig;

public class CatalogHdfsFileSystemKerberosAuthenticationModule
implements Module {
    private final boolean impersonationEnabled;

    public CatalogHdfsFileSystemKerberosAuthenticationModule(boolean impersonationEnabled) {
        this.impersonationEnabled = impersonationEnabled;
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogHdfsFileSystemConfig.class);
        if (this.impersonationEnabled) {
            binder.bind(HdfsAuthentication.class).to(DirectHdfsAuthentication.class).in(Scopes.SINGLETON);
        } else {
            OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHdfs.class)).setDefault().toInstance((Object)UserNameProvider.SIMPLE_USER_NAME_PROVIDER);
            binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
        }
    }

    @Inject
    @Provides
    @Singleton
    @ForHdfs
    HadoopAuthentication createHadoopAuthentication(CatalogHdfsFileSystemConfig config, HdfsConfigurationInitializer updater) {
        String principal = config.getKerberosPrincipal();
        KerberosConfiguration.Builder builder = new KerberosConfiguration.Builder().withKerberosPrincipal(principal);
        config.getKerberosKeytab().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withKeytabLocation(arg_0));
        config.getKerberosCredentialCacheLocation().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withCredentialCacheLocation(arg_0));
        return CatalogHdfsFileSystemKerberosAuthenticationModule.createCachingKerberosHadoopAuthentication(builder.build(), updater);
    }

    public static HadoopAuthentication createCachingKerberosHadoopAuthentication(KerberosConfiguration kerberosConfiguration, HdfsConfigurationInitializer updater) {
        KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(kerberosConfiguration);
        KerberosHadoopAuthentication kerberosHadoopAuthentication = KerberosHadoopAuthentication.createKerberosHadoopAuthentication((KerberosAuthentication)kerberosAuthentication, (HdfsConfigurationInitializer)updater);
        return new CachingKerberosHadoopAuthentication(kerberosHadoopAuthentication);
    }
}

