/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.hdfs;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.spi.CatalogResourceResolver;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public class CatalogHdfsFileSystemConfig {
    private static final String CONFIG_RESOURCES = "config-resources";
    private static final String IMPERSONATION_ENABLED = "impersonation-enabled";
    private static final String KERBEROS_PRINCIPAL = "kerberos-principal";
    private static final String KERBEROS_KEYTAB = "kerberos-keytab";
    private static final String KERBEROS_CREDENTIAL_CACHE_LOCATION = "kerberos-credential-cache-location";
    private List<String> resourceConfigFiles = ImmutableList.of();
    private boolean impersonationEnabled;
    private String kerberosPrincipal;
    private String kerberosKeytab;
    private String kerberosCredentialCacheLocation;

    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="config-resources")
    @ConfigDescription(value="Path to resources used for HDFS configuration")
    public CatalogHdfsFileSystemConfig setResourceConfigFiles(List<String> resourceConfigFiles) {
        this.resourceConfigFiles = resourceConfigFiles;
        return this;
    }

    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    @Config(value="impersonation-enabled")
    @ConfigDescription(value="Whether to impersonate users when communicating with HDFS")
    public CatalogHdfsFileSystemConfig setImpersonationEnabled(boolean impersonationEnabled) {
        this.impersonationEnabled = impersonationEnabled;
        return this;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    @Config(value="kerberos-principal")
    @ConfigDescription(value="Principal used to access HDFS")
    public CatalogHdfsFileSystemConfig setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
        return this;
    }

    public Optional<String> getKerberosKeytab() {
        return Optional.ofNullable(this.kerberosKeytab);
    }

    @Config(value="kerberos-keytab")
    @ConfigDescription(value="Keytab used to access HDFS")
    public CatalogHdfsFileSystemConfig setKerberosKeytab(String kerberosKeytab) {
        this.kerberosKeytab = kerberosKeytab;
        return this;
    }

    public Optional<String> getKerberosCredentialCacheLocation() {
        return Optional.ofNullable(this.kerberosCredentialCacheLocation);
    }

    @Config(value="kerberos-credential-cache-location")
    @ConfigDescription(value="Credential cache location used to access HDFS")
    public CatalogHdfsFileSystemConfig setKerberosCredentialCacheLocation(String kerberosCredentialCacheLocation) {
        this.kerberosCredentialCacheLocation = kerberosCredentialCacheLocation;
        return this;
    }

    public static Optional<String> validateProperties(Map<String, String> mutableConfig, CatalogResourceResolver resourceResolver) {
        String configResourcesString = mutableConfig.get(CONFIG_RESOURCES);
        if (configResourcesString == null) {
            return Optional.of(String.format("\"%s\" cannot be empty", CONFIG_RESOURCES));
        }
        CharSequence[] configResources = configResourcesString.split(",");
        for (int i = 0; i < configResources.length; ++i) {
            try {
                configResources[i] = resourceResolver.resolveResourcePath((String)configResources[i], "\"config-resources\"");
                continue;
            }
            catch (CatalogBadRequestException e) {
                return Optional.of(e.getOriginalMessage());
            }
        }
        mutableConfig.put(CONFIG_RESOURCES, String.join((CharSequence)",", configResources));
        String kerberosPrincipal = mutableConfig.get(KERBEROS_PRINCIPAL);
        String kerberosKeytab = mutableConfig.get(KERBEROS_KEYTAB);
        String kerberosCredentialCacheLocation = mutableConfig.get(KERBEROS_CREDENTIAL_CACHE_LOCATION);
        if (kerberosPrincipal != null) {
            if (kerberosKeytab == null && kerberosCredentialCacheLocation == null || kerberosKeytab != null && kerberosCredentialCacheLocation != null) {
                return Optional.of(String.format("\"%s\" or \"%s\" must be set when \"%s\" is present", KERBEROS_KEYTAB, KERBEROS_CREDENTIAL_CACHE_LOCATION, KERBEROS_PRINCIPAL));
            }
            if (kerberosKeytab != null) {
                mutableConfig.put(KERBEROS_KEYTAB, resourceResolver.resolveResourcePath(kerberosKeytab, KERBEROS_KEYTAB));
            }
            if (kerberosCredentialCacheLocation != null) {
                mutableConfig.put(KERBEROS_CREDENTIAL_CACHE_LOCATION, resourceResolver.resolveResourcePath(kerberosCredentialCacheLocation, KERBEROS_CREDENTIAL_CACHE_LOCATION));
            }
        } else {
            if (kerberosKeytab != null) {
                return Optional.of(String.format("\"%s\" should not be set without \"%s\"", KERBEROS_KEYTAB, KERBEROS_PRINCIPAL));
            }
            if (kerberosCredentialCacheLocation != null) {
                return Optional.of(String.format("\"%s\" should not be set without \"%s\"", KERBEROS_CREDENTIAL_CACHE_LOCATION, KERBEROS_PRINCIPAL));
            }
        }
        HashMap<String, String> unusedConfig = new HashMap<String, String>(mutableConfig);
        for (Method method : CatalogHdfsFileSystemConfig.class.getMethods()) {
            Config config = method.getAnnotation(Config.class);
            if (config == null) continue;
            unusedConfig.remove(config.value());
        }
        if (!unusedConfig.isEmpty()) {
            return Optional.of(String.format("Unsupported property: \"%s\"", unusedConfig.keySet().iterator().next()));
        }
        return Optional.empty();
    }
}

