/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.filesystem.FileSystemDetails;
import ru.cedrusdata.catalog.core.principal.PrincipalDetails;
import ru.cedrusdata.catalog.core.principal.PrincipalIdAndType;
import ru.cedrusdata.catalog.core.principal.PrincipalType;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.store.CatalogStore;
import ru.cedrusdata.catalog.tracing.TracingScopedSpan;

public class TracingCatalogStore
implements CatalogStore {
    private final CatalogStore delegate;
    private final Tracer tracer;

    public TracingCatalogStore(CatalogStore delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.delegate.initialize();
    }

    @Override
    public Optional<UUID> createPrincipalIfNotExists(String principalName, PrincipalType principalType, String hashedPassword, Map<UUID, String> roles, boolean active, Map<String, String> properties) {
        Span span = this.startSpan("createPrincipalIfNotExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<UUID> optional = this.delegate.createPrincipalIfNotExists(principalName, principalType, hashedPassword, roles, active, properties);
            return optional;
        }
    }

    @Override
    public boolean updatePrincipalIfExists(UUID principalId, String newPrincipalName, boolean newActive, Map<String, String> newProperties, Optional<String> newHashedPassword) {
        Span span = this.startSpan("updatePrincipalIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.updatePrincipalIfExists(principalId, newPrincipalName, newActive, newProperties, newHashedPassword);
            return bl;
        }
    }

    @Override
    public boolean deletePrincipalIfExists(UUID principalId, String principalName) {
        Span span = this.startSpan("deletePrincipalIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.deletePrincipalIfExists(principalId, principalName);
            return bl;
        }
    }

    @Override
    public Optional<UUID> getPrincipalIdByName(String principalName) {
        Span span = this.startSpan("getPrincipalIdByName");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<UUID> optional = this.delegate.getPrincipalIdByName(principalName);
            return optional;
        }
    }

    @Override
    public Optional<PrincipalDetails> getPrincipalDetailsByName(String principalName, boolean readPassword) {
        Span span = this.startSpan("getPrincipalDetailsByName");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<PrincipalDetails> optional = this.delegate.getPrincipalDetailsByName(principalName, readPassword);
            return optional;
        }
    }

    @Override
    public Optional<PrincipalDetails> getPrincipalDetailsByAccessTokenId(String accessTokenId) {
        Span span = this.startSpan("getPrincipalDetailsByAccessTokenId");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<PrincipalDetails> optional = this.delegate.getPrincipalDetailsByAccessTokenId(accessTokenId);
            return optional;
        }
    }

    @Override
    public Optional<PrincipalInfo> getPrincipal(String principalName) {
        Span span = this.startSpan("getPrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<PrincipalInfo> optional = this.delegate.getPrincipal(principalName);
            return optional;
        }
    }

    @Override
    public Map<String, PrincipalIdAndType> getPrincipalIdAndType(Collection<String> principalNames) {
        Span span = this.startSpan("getPrincipalIdAndType");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Map<String, PrincipalIdAndType> map = this.delegate.getPrincipalIdAndType(principalNames);
            return map;
        }
    }

    @Override
    public PrincipalListResponse listPrincipals(Optional<String> principalType, ResultPage page) {
        Span span = this.startSpan("listPrincipals");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrincipalListResponse principalListResponse = this.delegate.listPrincipals(principalType, page);
            return principalListResponse;
        }
    }

    @Override
    public long countUserPrincipals() {
        Span span = this.startSpan("countUserPrincipals");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            long l = this.delegate.countUserPrincipals();
            return l;
        }
    }

    @Override
    public void createAccessToken(UUID principalId, String principalName, String accessTokenId, String hashedAccessToken, String description) {
        Span span = this.startSpan("createAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createAccessToken(principalId, principalName, accessTokenId, hashedAccessToken, description);
        }
    }

    @Override
    public boolean deleteAccessTokenIfExists(String accessTokenId) {
        Span span = this.startSpan("deleteAccessTokenIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.deleteAccessTokenIfExists(accessTokenId);
            return bl;
        }
    }

    @Override
    public AccessTokenListResponse listAccessTokens(ResultPage page) {
        Span span = this.startSpan("listAccessTokens");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenListResponse accessTokenListResponse = this.delegate.listAccessTokens(page);
            return accessTokenListResponse;
        }
    }

    @Override
    public AccessTokenListResponse listPrincipalAccessTokens(UUID principalId, ResultPage page) {
        Span span = this.startSpan("listPrincipalAccessTokens");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenListResponse accessTokenListResponse = this.delegate.listPrincipalAccessTokens(principalId, page);
            return accessTokenListResponse;
        }
    }

    @Override
    public List<String> listPrincipalAccessTokenIds(UUID principalId) {
        Span span = this.startSpan("listPrincipalAccessTokenIds");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            List<String> list = this.delegate.listPrincipalAccessTokenIds(principalId);
            return list;
        }
    }

    @Override
    public Map<String, UUID> listRoles() {
        Span span = this.startSpan("listRoles");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Map<String, UUID> map = this.delegate.listRoles();
            return map;
        }
    }

    @Override
    public boolean grantRoleIfNotGranted(UUID principalId, String principalName, UUID roleId, String roleName) {
        Span span = this.startSpan("grantRoleIfNotGranted");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.grantRoleIfNotGranted(principalId, principalName, roleId, roleName);
            return bl;
        }
    }

    @Override
    public boolean revokeRoleIfGranted(UUID principalId, UUID roleId) {
        Span span = this.startSpan("revokeRoleIfGranted");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.revokeRoleIfGranted(principalId, roleId);
            return bl;
        }
    }

    @Override
    public boolean createFileSystemIfNotExists(UUID id, String name, String description, CatalogFileSystemType type, Map<String, String> properties) {
        Span span = this.startSpan("createFileSystemIfNotExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.createFileSystemIfNotExists(id, name, description, type, properties);
            return bl;
        }
    }

    @Override
    public boolean updateFileSystemIfExists(UUID id, String name, String description, Map<String, String> properties) {
        Span span = this.startSpan("updateFileSystemIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.updateFileSystemIfExists(id, name, description, properties);
            return bl;
        }
    }

    @Override
    public boolean deleteFileSystemIfExists(UUID id, String name) {
        Span span = this.startSpan("fileSystemDeleteIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.deleteFileSystemIfExists(id, name);
            return bl;
        }
    }

    @Override
    public Optional<FileSystemDetails> fileSystemDetails(String name) {
        Span span = this.startSpan("fileSystemDetails");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<FileSystemDetails> optional = this.delegate.fileSystemDetails(name);
            return optional;
        }
    }

    @Override
    public List<FileSystemDetails> fileSystemAllDetails() {
        Span span = this.startSpan("fileSystemAllDetails");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            List<FileSystemDetails> list = this.delegate.fileSystemAllDetails();
            return list;
        }
    }

    @Override
    public Optional<FileSystemInfo> getFileSystem(String name) {
        Span span = this.startSpan("getFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<FileSystemInfo> optional = this.delegate.getFileSystem(name);
            return optional;
        }
    }

    @Override
    public FileSystemListResponse listFileSystems(ResultPage page) {
        Span span = this.startSpan("listFileSystems");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            FileSystemListResponse fileSystemListResponse = this.delegate.listFileSystems(page);
            return fileSystemListResponse;
        }
    }

    @Override
    public Optional<UUID> createIcebergCatalogIfNotExists(String catalogName, String description, UUID fileSystemId, String fileSystemName, String fileSystemLocation, Map<String, String> properties) {
        Span span = this.startSpan("createIcebergCatalogIfNotExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<UUID> optional = this.delegate.createIcebergCatalogIfNotExists(catalogName, description, fileSystemId, fileSystemName, fileSystemLocation, properties);
            return optional;
        }
    }

    @Override
    public boolean updateIcebergCatalogIfExists(UUID catalogId, String catalogName, String description, String fileSystemLocation, Map<String, String> properties) {
        Span span = this.startSpan("updateIcebergCatalogIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.updateIcebergCatalogIfExists(catalogId, catalogName, description, fileSystemLocation, properties);
            return bl;
        }
    }

    @Override
    public boolean deleteIcebergCatalogIfExists(UUID catalogId, String catalogName) {
        Span span = this.startSpan("deleteIcebergCatalogIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.deleteIcebergCatalogIfExists(catalogId, catalogName);
            return bl;
        }
    }

    @Override
    public List<IcebergCatalogDetails> listIcebergCatalogDetails() {
        Span span = this.startSpan("listIcebergCatalogDetails");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            List<IcebergCatalogDetails> list = this.delegate.listIcebergCatalogDetails();
            return list;
        }
    }

    @Override
    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage page) {
        Span span = this.startSpan("listIcebergCatalogs");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergCatalogListResponse icebergCatalogListResponse = this.delegate.listIcebergCatalogs(page);
            return icebergCatalogListResponse;
        }
    }

    @Override
    public Optional<UUID> createIcebergNamespaceIfNotExists(String namespaceName, UUID catalogId, String catalogName, Map<String, String> properties) {
        Span span = this.startSpan("icebergNamespaceCreateIfNotExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<UUID> optional = this.delegate.createIcebergNamespaceIfNotExists(namespaceName, catalogId, catalogName, properties);
            return optional;
        }
    }

    @Override
    public boolean updateIcebergNamespaceIfExists(UUID namespaceId, Map<String, String> properties) {
        Span span = this.startSpan("icebergNamespaceUpdateIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.updateIcebergNamespaceIfExists(namespaceId, properties);
            return bl;
        }
    }

    @Override
    public boolean deleteIcebergNamespaceIfExists(UUID namespaceId, String namespaceName, String catalogName) {
        Span span = this.startSpan("icebergNamespaceDeleteIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.deleteIcebergNamespaceIfExists(namespaceId, namespaceName, catalogName);
            return bl;
        }
    }

    @Override
    public List<IcebergNamespaceDetails> listIcebergNamespaceDetails() {
        Span span = this.startSpan("listIcebergNamespaceDetails");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            List<IcebergNamespaceDetails> list = this.delegate.listIcebergNamespaceDetails();
            return list;
        }
    }

    @Override
    public IcebergNamespaceListResponse listIcebergNamespacesForApi(Optional<String> catalog, ResultPage page) {
        Span span = this.startSpan("listIcebergNamespacesForApi");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergNamespaceListResponse icebergNamespaceListResponse = this.delegate.listIcebergNamespacesForApi(catalog, page);
            return icebergNamespaceListResponse;
        }
    }

    @Override
    public IcebergNamespaceListResult listIcebergNamespaces(UUID catalogId, ResultPage page) {
        Span span = this.startSpan("listIcebergNamespaces");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergNamespaceListResult icebergNamespaceListResult = this.delegate.listIcebergNamespaces(catalogId, page);
            return icebergNamespaceListResult;
        }
    }

    @Override
    public boolean createIcebergTableIfNotExist(UUID namespaceId, String tableName, IcebergTableType tableType, String metadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails) {
        Span span = this.startSpan("createIcebergTableIfNotExist");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.createIcebergTableIfNotExist(namespaceId, tableName, tableType, metadataLocation, materializedViewDetails);
            return bl;
        }
    }

    @Override
    public boolean updateIcebergTableIfExists(UUID namespaceId, String tableName, IcebergTableType tableType, String metadataLocation, String previousMetadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails) {
        Span span = this.startSpan("updateIcebergTableMetadataLocation");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.updateIcebergTableIfExists(namespaceId, tableName, tableType, metadataLocation, previousMetadataLocation, materializedViewDetails);
            return bl;
        }
    }

    @Override
    public boolean renameIcebergTableIfExists(String catalogName, UUID fromNamespaceId, String fromTableName, String toNamespaceName, UUID toNamespaceId, String toTableName, IcebergTableType tableType) {
        Span span = this.startSpan("renameIcebergTableIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.renameIcebergTableIfExists(catalogName, fromNamespaceId, fromTableName, toNamespaceName, toNamespaceId, toTableName, tableType);
            return bl;
        }
    }

    @Override
    public boolean deleteIcebergTableIfExists(UUID namespaceId, String tableName, IcebergTableType tableType) {
        Span span = this.startSpan("deleteIcebergTableIfExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.deleteIcebergTableIfExists(namespaceId, tableName, tableType);
            return bl;
        }
    }

    @Override
    public Optional<String> getIcebergTableMetadataLocation(String catalogName, String namespaceName, UUID namespaceId, String tableName, IcebergTableType tableType) {
        Span span = this.startSpan("getIcebergTableMetadataLocation");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<String> optional = this.delegate.getIcebergTableMetadataLocation(catalogName, namespaceName, namespaceId, tableName, tableType);
            return optional;
        }
    }

    @Override
    public IcebergTableListResult listIcebergTables(UUID namespaceId, IcebergTableType tableType, ResultPage page) {
        Span span = this.startSpan("listIcebergTables");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergTableListResult icebergTableListResult = this.delegate.listIcebergTables(namespaceId, tableType, page);
            return icebergTableListResult;
        }
    }

    @Override
    public IcebergObjectListResponse listIcebergObjectsForApi(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        Span span = this.startSpan("listIcebergObjectsForApi");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergObjectListResponse icebergObjectListResponse = this.delegate.listIcebergObjectsForApi(catalogName, namespaceName, objectType, page);
            return icebergObjectListResponse;
        }
    }

    @Override
    public Optional<IcebergObjectInfo> getIcebergObjectForApi(String catalogName, String namespaceName, String objectName) {
        Span span = this.startSpan("getIcebergObjectForApi");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            Optional<IcebergObjectInfo> optional = this.delegate.getIcebergObjectForApi(catalogName, namespaceName, objectName);
            return optional;
        }
    }

    @Override
    public IcebergMaterializedViewForRewriteListResponse listIcebergMaterializedViewsForRewriteForApi(String catalogName, Set<String> tableNames) {
        Span span = this.startSpan("listIcebergMaterializedViewsForRewriteForApi");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergMaterializedViewForRewriteListResponse icebergMaterializedViewForRewriteListResponse = this.delegate.listIcebergMaterializedViewsForRewriteForApi(catalogName, tableNames);
            return icebergMaterializedViewForRewriteListResponse;
        }
    }

    private Span startSpan(String methodName) {
        return this.tracer.spanBuilder("store." + methodName).startSpan();
    }
}

