/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc.sqlite;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.sqlite.SQLiteConfig;
import ru.cedrusdata.catalog.config.store.CatalogJdbcSqliteStoreConfig;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.store.CatalogStore;
import ru.cedrusdata.catalog.store.jdbc.ForTracing;
import ru.cedrusdata.catalog.store.jdbc.JdbcCatalogStoreAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcConnectionDetails;
import ru.cedrusdata.catalog.store.jdbc.JdbcDatabaseType;
import ru.cedrusdata.catalog.store.jdbc.sqlite.SqliteCatalogStore;

public class SqliteCatalogStoreModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogJdbcSqliteStoreConfig.class);
    }

    @Provides
    @Singleton
    @ForTracing
    public static CatalogStore getCatalogStore(JdbcCatalogStoreAccessor accessor, CatalogStoreConfig config) {
        return new SqliteCatalogStore(accessor, config);
    }

    @Provides
    @Singleton
    public static JdbcConnectionDetails getConnectionDetails(CatalogJdbcSqliteStoreConfig config) {
        SqliteCatalogStoreModule.createDatabaseDirectory(config.getStoreSqlitePath());
        String jdbcUrl = "jdbc:sqlite:" + String.valueOf(config.getStoreSqlitePath());
        SQLiteConfig sqliteConfig = new SQLiteConfig();
        sqliteConfig.enforceForeignKeys(true);
        sqliteConfig.setJournalMode(SQLiteConfig.JournalMode.WAL);
        return new JdbcConnectionDetails(JdbcDatabaseType.SQLITE, jdbcUrl, Optional.empty(), Optional.empty(), sqliteConfig.toProperties(), false);
    }

    private static void createDatabaseDirectory(File databaseFile) {
        File dir = databaseFile.getParentFile();
        if (dir != null) {
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new CatalogInternalServerErrorException(String.format("Failed to create parent directory for SQLite database file %s: %s", databaseFile, e.getMessage()), (Throwable)e);
            }
        }
    }
}

