/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc.postgres;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import org.postgresql.util.PSQLException;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.store.jdbc.AbstractJdbcCatalogStore;
import ru.cedrusdata.catalog.store.jdbc.JdbcCatalogStoreAccessor;

public class PostgresqlCatalogStore
extends AbstractJdbcCatalogStore {
    private static final Set<String> CONSTRAINT_VIOLATION_SQL_STATES_CODES = Set.of("23000", "23001", "23502", "23503", "23505", "23514", "23P01");

    @Inject
    public PostgresqlCatalogStore(JdbcCatalogStoreAccessor accessor, CatalogStoreConfig config) {
        super(accessor, config);
    }

    @Override
    protected boolean isConstraintViolationExceptionInternal(Throwable throwable) {
        if (throwable instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)throwable;
            return CONSTRAINT_VIOLATION_SQL_STATES_CODES.contains(psqlException.getSQLState());
        }
        return false;
    }

    @Override
    protected UUID getUuid(ResultSet rs, String columnLabel) throws SQLException {
        return rs.getObject(columnLabel, UUID.class);
    }

    @Override
    protected String forUpdate(String sql) {
        return sql.replace("{for-update}", "FOR UPDATE");
    }
}

