/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import java.util.UUID;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

@FunctionalInterface
public interface PageProcessorPageTokenConverter {
    public static final PageProcessorPageTokenConverter AS_VARCHAR = pageToken -> pageToken;
    public static final PageProcessorPageTokenConverter AS_UUID = pageToken -> {
        try {
            return pageToken != null ? UUID.fromString(pageToken) : null;
        }
        catch (NumberFormatException e) {
            throw new CatalogBadRequestException(String.format("Bad next page token \"%s\"", pageToken));
        }
    };

    public Object convert(String var1);
}

