/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.base.Function;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessor;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorPageTokenConverter;

public class PageProcessorFactory<T> {
    private final ListQueryBuilder listQueryBuilder;
    private final int maxPageSize;
    private final PageProcessorPageTokenConverter pageTokenConverter;
    private final Function<T, Object> extractor;

    public PageProcessorFactory(ListQueryBuilder listQueryBuilder, int maxPageSize, PageProcessorPageTokenConverter pageTokenConverter, Function<T, Object> extractor) {
        this.listQueryBuilder = listQueryBuilder;
        this.maxPageSize = maxPageSize;
        this.pageTokenConverter = pageTokenConverter;
        this.extractor = extractor;
    }

    public PageProcessor<T> create(ResultPage page) {
        int limit = Math.min(this.maxPageSize, page.pageSize().isPresent() ? page.pageSize().getAsInt() : Integer.MAX_VALUE);
        return new PageProcessor<T>(this.listQueryBuilder, page.pageToken(), limit, this.pageTokenConverter, this.extractor);
    }
}

