/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorPageTokenConverter;

public class PageProcessor<T> {
    private final ListQueryBuilder listQueryBuilder;
    private final Optional<String> pageToken;
    private final int limit;
    private final PageProcessorPageTokenConverter pageTokenConverter;
    private final Function<T, Object> extractor;

    public PageProcessor(ListQueryBuilder listQueryBuilder, Optional<String> pageToken, int limit, PageProcessorPageTokenConverter pageTokenConverter, Function<T, Object> extractor) {
        this.listQueryBuilder = listQueryBuilder;
        this.pageToken = pageToken;
        this.limit = limit;
        this.pageTokenConverter = pageTokenConverter;
        this.extractor = extractor;
    }

    public Query createQuery(Handle handle) {
        return this.createQuery(handle, List.of(), Map.of());
    }

    public Query createQuery(Handle handle, List<String> conditions, Map<String, Object> bindings) {
        String sql = (this.pageToken.isEmpty() ? this.listQueryBuilder.withoutOffset() : this.listQueryBuilder.withOffset()).build(conditions);
        Query query = handle.createQuery(sql);
        if (bindings != null) {
            bindings.forEach((arg_0, arg_1) -> ((Query)query).bind(arg_0, arg_1));
        }
        if (this.pageToken.isPresent()) {
            query.bind("offset", this.pageTokenConverter.convert(this.pageToken.get()));
        }
        query.bind("limit", this.limit);
        return query;
    }

    public String nextPageToken(List<T> results) {
        if (results == null || this.limit > results.size()) {
            return null;
        }
        Object value = this.extractor.apply(results.get(results.size() - 1));
        Verify.verify((value != null ? 1 : 0) != 0);
        return value.toString();
    }
}

