/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.annotations.Language;

public class ListQueryBuilder {
    public static final String PARAM_OFFSET = "offset";
    public static final String PARAM_LIMIT = "limit";
    @Language(value="SQL")
    private final String baseQuery;
    private final String sortColumn;
    private final boolean offset;

    public static ListQueryBuilder createQueryBuilder(@Language(value="SQL") String baseQuery, String sortColumn) {
        return new ListQueryBuilder(baseQuery, sortColumn, false);
    }

    private ListQueryBuilder(@Language(value="SQL") String baseQuery, String sortColumn, boolean offset) {
        this.baseQuery = baseQuery.trim();
        this.sortColumn = sortColumn;
        this.offset = offset;
    }

    public ListQueryBuilder withOffset() {
        return this.offset ? this : new ListQueryBuilder(this.baseQuery, this.sortColumn, true);
    }

    public ListQueryBuilder withoutOffset() {
        return !this.offset ? this : new ListQueryBuilder(this.baseQuery, this.sortColumn, false);
    }

    @Language(value="SQL")
    public String build() {
        return this.build(List.of());
    }

    @Language(value="SQL")
    public String build(List<String> conditions) {
        if (conditions == null) {
            conditions = List.of();
        }
        if (this.offset) {
            ArrayList<Object> allConditions = new ArrayList<Object>(conditions.size());
            allConditions.addAll(conditions);
            allConditions.add(this.sortColumn + " > :offset");
            conditions = allConditions;
        }
        return this.buildInternal(conditions);
    }

    private String buildInternal(Collection<String> conditions) {
        StringBuilder res = new StringBuilder(this.baseQuery);
        if (!conditions.isEmpty()) {
            res.append("\nWHERE ");
            boolean first = true;
            for (String condition : conditions) {
                if (first) {
                    first = false;
                } else {
                    res.append(" AND ");
                }
                res.append(condition);
            }
        }
        res.append("\nORDER BY ").append(this.sortColumn);
        res.append("\nLIMIT :").append(PARAM_LIMIT);
        return res.toString();
    }
}

