/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import java.util.Optional;

public enum JdbcDatabaseType {
    SQLITE("jdbc:sqlite", "postgresql", Optional.empty()),
    POSTGRESQL("jdbc:postgresql", "postgresql", Optional.of("SET search_path TO %s"));

    private final String jdbcUrlPrefix;
    private final String resourcePrefix;
    private final Optional<String> setSchemaSql;

    private JdbcDatabaseType(String jdbcUrlPrefix, String resourcePrefix, Optional<String> setSchemaSql) {
        this.jdbcUrlPrefix = jdbcUrlPrefix;
        this.resourcePrefix = resourcePrefix;
        this.setSchemaSql = setSchemaSql;
    }

    public static Optional<JdbcDatabaseType> resolveFromJdbcUrl(String jdbcUrl) {
        if (jdbcUrl != null) {
            for (JdbcDatabaseType type : JdbcDatabaseType.values()) {
                if (!jdbcUrl.startsWith(type.getJdbcUrlPrefix())) continue;
                return Optional.of(type);
            }
        }
        return Optional.empty();
    }

    public String getJdbcUrlPrefix() {
        return this.jdbcUrlPrefix;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public Optional<String> getSetSchemaSql() {
        return this.setSchemaSql;
    }
}

