/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.trace.Tracer;
import java.util.Optional;
import javax.sql.DataSource;
import org.jdbi.v3.core.ConnectionFactory;
import ru.cedrusdata.catalog.config.store.CatalogJdbcStoreConfig;
import ru.cedrusdata.catalog.store.CatalogStore;
import ru.cedrusdata.catalog.store.jdbc.ForTracing;
import ru.cedrusdata.catalog.store.jdbc.JdbcCatalogStoreAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcConnectionDetails;
import ru.cedrusdata.catalog.store.jdbc.JdbcDirectConnectionFactory;
import ru.cedrusdata.catalog.store.jdbc.JdbcDirectDataSource;
import ru.cedrusdata.catalog.store.jdbc.JdbcHikariDataSourceConnectionFactory;
import ru.cedrusdata.catalog.tracing.TracingCatalogStore;
import ru.cedrusdata.catalog.tracing.TracingProvider;

public class JdbcCatalogStoreModule
extends AbstractConfigurationAwareModule {
    private final Module baseModule;

    public JdbcCatalogStoreModule(Module baseModule) {
        this.baseModule = baseModule;
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogJdbcStoreConfig.class);
        binder.bind(JdbcCatalogStoreAccessor.class).in(Scopes.SINGLETON);
        super.install(this.baseModule);
    }

    @Provides
    @Singleton
    public static CatalogStore getCatalogStore(@ForTracing CatalogStore store, TracingProvider tracingProvider) {
        Optional<Tracer> tracer = tracingProvider.tracerForStore();
        if (tracer.isPresent()) {
            store = new TracingCatalogStore(store, tracer.get());
        }
        return store;
    }

    @Provides
    @Singleton
    public static JdbcDirectConnectionFactory getDirectConnectionFactory(JdbcConnectionDetails connectionDetails) {
        return new JdbcDirectConnectionFactory(connectionDetails);
    }

    @Provides
    @Singleton
    public static ConnectionFactory getConnectionFactory(JdbcDirectConnectionFactory directConnectionFactory, CatalogJdbcStoreConfig config) {
        if (config.getStoreJdbcConnectionPoolSize() > 0) {
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setMaximumPoolSize(config.getStoreJdbcConnectionPoolSize());
            hikariConfig.setIdleTimeout(config.getStoreJdbcConnectionPoolTtl().toMillis());
            hikariConfig.setDataSource((DataSource)new JdbcDirectDataSource(directConnectionFactory));
            HikariDataSource dataSource = new HikariDataSource(hikariConfig);
            return new JdbcHikariDataSourceConnectionFactory(dataSource);
        }
        return directConnectionFactory;
    }
}

