/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.output.MigrateResult;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.store.NestedStoreException;
import ru.cedrusdata.catalog.store.jdbc.JdbcConnectionDetails;

public class JdbcCatalogStoreAccessor {
    private static final Logger log = Logger.get(JdbcCatalogStoreAccessor.class);
    private static final String SCHEMA = "cedrusdata_catalog";
    private final JdbcConnectionDetails connectionDetails;
    private final Jdbi jdbi;

    @Inject
    public JdbcCatalogStoreAccessor(JdbcConnectionDetails connectionDetails, ConnectionFactory connectionFactory) {
        this.connectionDetails = connectionDetails;
        this.jdbi = Jdbi.create((ConnectionFactory)connectionFactory);
    }

    public void migrate() {
        log.info("Started Flyway migration");
        String location = String.format("/jdbc/%s", this.connectionDetails.databaseType().getResourcePrefix());
        FluentConfiguration flywayConfig = Flyway.configure().dataSource(this.connectionDetails.url(), (String)this.connectionDetails.user().orElse(null), (String)this.connectionDetails.password().orElse(null)).jdbcProperties(this.connectionDetails.propertiesAsMap()).locations(new String[]{location}).baselineOnMigrate(true).baselineVersion("0").target(MigrationVersion.LATEST).failOnMissingLocations(true);
        if (this.connectionDetails.supportSchemas()) {
            flywayConfig.schemas(new String[]{SCHEMA});
        }
        Flyway flyway = flywayConfig.load();
        MigrateResult migrations = flyway.migrate();
        log.info("Completed Flyway migration for %s", new Object[]{migrations.migrationsExecuted});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Function<Handle, T> command) {
        try (Handle handle = this.jdbi.open();){
            Handle t = command.apply(this.withSchema(handle));
            return (T)t;
        }
        catch (NestedStoreException e) {
            throw e.getOriginalCause();
        }
        catch (Exception e) {
            throw new CatalogInternalServerErrorException(String.format("Failed to execute catalog store operation: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void execute(Consumer<Handle> command) {
        this.execute((Handle handle) -> {
            command.accept((Handle)handle);
            return null;
        });
    }

    private Handle withSchema(Handle handle) {
        Optional<String> setSchemaSql = this.connectionDetails.databaseType().getSetSchemaSql();
        if (setSchemaSql.isPresent()) {
            String setSchemaCommand = String.format(setSchemaSql.get(), SCHEMA);
            handle.execute(setSchemaCommand, new Object[0]);
        }
        return handle;
    }
}

