/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.airlift.json.JsonCodec;
import jakarta.annotation.PostConstruct;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.filesystem.FileSystemDetails;
import ru.cedrusdata.catalog.core.principal.PrincipalDetails;
import ru.cedrusdata.catalog.core.principal.PrincipalIdAndType;
import ru.cedrusdata.catalog.core.principal.PrincipalType;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergMaterializedViewSnapshotDetails;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemInUseException;
import ru.cedrusdata.catalog.spi.exception.CatalogPrincipalAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.CatalogPrincipalDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.CatalogPrincipalInUseException;
import ru.cedrusdata.catalog.spi.exception.CatalogRecursiveRoleGrantException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogInUseException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceNotEmptyException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.model.AccessTokenInfo;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteInfo;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.store.CatalogStore;
import ru.cedrusdata.catalog.store.NestedStoreException;
import ru.cedrusdata.catalog.store.jdbc.JdbcCatalogStoreAccessor;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessor;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorPageTokenConverter;

public abstract class AbstractJdbcCatalogStore
implements CatalogStore {
    private static final JsonCodec<Map<String, String>> PROPERTIES_CODEC = JsonCodec.mapJsonCodec(String.class, String.class);
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_CREATE = "INSERT INTO metastore_principal (\n    principal_id,\n    principal_name,\n    principal_type,\n    hashed_password,\n    active,\n    properties)\nVALUES (\n    :principal_id,\n    :principal_name,\n    :principal_type,\n    :hashed_password,\n    :active,\n    :properties)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_UPDATE_TEMPLATE = "UPDATE metastore_principal\nSET\n    %s\nWHERE principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DELETE = "DELETE FROM metastore_principal\nWHERE principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_USER_COUNT = "SELECT\n    COUNT(*)\nFROM metastore_principal\nWHERE principal_type = 0\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_FOR_UPDATE = "SELECT\n    principal_id\nFROM metastore_principal\nWHERE principal_id = :principal_id\n{for-update}\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_INFO = "SELECT\n    u.principal_id,\n    u.principal_name,\n    u.principal_type,\n    u.active,\n    (SELECT string_agg(r.principal_name, ',') FROM metastore_role_grant rg INNER JOIN metastore_principal r ON rg.role_id = r.principal_id WHERE rg.principal_id = u.principal_id) role_names,\n    u.properties\nFROM metastore_principal u\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_ID_AND_TYPE = "SELECT\n    principal_id,\n    principal_type,\n    principal_name\nFROM metastore_principal\nWHERE principal_name IN ({referenced_principal_names})\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_LIST = "SELECT\n    u.principal_id,\n    u.principal_name,\n    u.principal_type,\n    (SELECT string_agg(r.principal_name, ',') FROM metastore_role_grant rg INNER JOIN metastore_principal r ON rg.role_id = r.principal_id WHERE rg.principal_id = u.principal_id) role_names,\n    u.active,\n    u.properties\nFROM metastore_principal u\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_ID = "SELECT\n    u.principal_id\nFROM metastore_principal u\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DETAILS_WITHOUT_PASSWORD = "SELECT\n    u.principal_id,\n    u.principal_name,\n    u.principal_type,\n    u.active,\n    (SELECT string_agg(CAST(rg.role_id AS VARCHAR), ',') FROM metastore_role_grant rg WHERE rg.principal_id = u.principal_id) role_ids,\n    u.properties\nFROM metastore_principal u\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DETAILS_WITH_PASSWORD = "SELECT\n    u.principal_id,\n    u.principal_name,\n    u.principal_type,\n    u.active,\n    u.hashed_password,\n    (SELECT string_agg(CAST(rg.role_id AS VARCHAR), ',') FROM metastore_role_grant rg WHERE rg.principal_id = u.principal_id) role_ids,\n    u.properties\nFROM metastore_principal u\nWHERE u.principal_name = :principal_name\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_DETAILS_BY_ACCESS_TOKEN_ID = "SELECT\n    u.principal_id,\n    u.principal_name,\n    u.principal_type,\n    u.active,\n    t.hashed_access_token,\n    (SELECT string_agg(CAST(rg.role_id AS VARCHAR), ',') FROM metastore_role_grant rg WHERE rg.principal_id = u.principal_id) role_ids,\n    u.properties\nFROM metastore_access_token t\n    INNER JOIN metastore_principal u ON t.principal_id = u.principal_id\nWHERE t.access_token_id = :access_token_id\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_ROLES = "SELECT\n    principal_id,\n    role_id\nFROM metastore_role_grant\nWHERE principal_id IN ({referenced_role_ids})\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_CREATE = "INSERT INTO metastore_access_token (\n    access_token_id,\n    hashed_access_token,\n    principal_id,\n    description)\nVALUES (\n    :access_token_id,\n    :hashed_access_token,\n    :principal_id,\n    :description)\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_DELETE = "DELETE FROM metastore_access_token\nWHERE :access_token_id = access_token_id\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_LIST = "SELECT\n    at.access_token_id,\n    u.principal_name,\n    at.description\nFROM metastore_access_token at\n    INNER JOIN metastore_principal u ON at.principal_id = u.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_LIST_FOR_PRINCIPAL = "SELECT\n    at.access_token_id,\n    u.principal_name,\n    at.description\nFROM metastore_access_token at\n    INNER JOIN metastore_principal u ON at.principal_id = u.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_ACCESS_TOKEN_ID_LIST = "SELECT\n    access_token_id\nFROM metastore_access_token\nWHERE principal_id = :principal_id\n";
    @Language(value="SQL")
    private static final String SQL_ROLE_LIST = "SELECT\n    principal_id,\n    principal_name\nFROM metastore_principal\nWHERE principal_type = 1\n";
    @Language(value="SQL")
    private static final String SQL_PRINCIPAL_NAMES = "SELECT\n    principal_id,\n    principal_name\nFROM metastore_principal\nWHERE principal_id IN ({referenced_role_ids})\n";
    @Language(value="SQL")
    private static final String SQL_ROLE_GRANT = "INSERT INTO metastore_role_grant (\n    principal_id,\n    role_id)\nVALUES (\n    :principal_id,\n    :role_id)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_ROLE_REVOKE = "DELETE FROM metastore_role_grant\nWHERE principal_id = :principal_id AND role_id = :role_id\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_CREATE = "INSERT INTO metastore_file_system (\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    description,\n    properties)\nVALUES (\n    :file_system_id,\n    :file_system_name,\n    :file_system_type,\n    :description,\n    :properties)\nON CONFLICT DO NOTHING";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_UPDATE = "UPDATE metastore_file_system\nSET\n    file_system_name = :file_system_name,\n    description = :description,\n    properties = :properties\nWHERE file_system_id = :file_system_id\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_DELETE = "DELETE FROM metastore_file_system\nWHERE file_system_id = :file_system_id\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_DETAILS = "SELECT\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    description,\n    properties\nFROM metastore_file_system\nWHERE file_system_name = :file_system_name\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_DETAILS_ALL = "SELECT\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    description,\n    properties\nFROM metastore_file_system\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_INFO = "SELECT\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    description,\n    properties\nFROM metastore_file_system\nWHERE file_system_name = :file_system_name";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_LIST = "SELECT\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    description,\n    properties\nFROM metastore_file_system\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_CREATE = "INSERT INTO metastore_catalog (\n    catalog_id,\n    catalog_name,\n    description,\n    file_system_id,\n    file_system_location,\n    properties)\nVALUES (\n    :catalog_id,\n    :catalog_name,\n    :description,\n    :file_system_id,\n    :file_system_location,\n    :properties)\nON CONFLICT DO NOTHING";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_UPDATE = "UPDATE metastore_catalog\nSET\n    catalog_name = :catalog_name,\n    description = :description,\n    file_system_location = :file_system_location,\n    properties = :properties\nWHERE catalog_id = :catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_DELETE = "DELETE FROM metastore_catalog\nWHERE catalog_id = :catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_INFO_ALL = "SELECT\n    catalog_id,\n    catalog_name,\n    description,\n    file_system_id,\n    file_system_location,\n    properties\nFROM metastore_catalog\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_LIST = "SELECT\n    c.catalog_id,\n    c.catalog_name,\n    c.description,\n    f.file_system_name,\n    c.file_system_location,\n    c.properties\nFROM metastore_catalog c\n    INNER JOIN metastore_file_system f ON c.file_system_id = f.file_system_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_CREATE = "INSERT INTO metastore_iceberg_namespace (\n    namespace_id,\n    namespace_name,\n    catalog_id,\n    properties)\nVALUES (\n    :namespace_id,\n    :namespace_name,\n    :catalog_id,\n    :properties)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_UPDATE = "UPDATE metastore_iceberg_namespace\nSET\n    properties = :properties\nWHERE namespace_id = :namespace_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_DELETE = "DELETE FROM metastore_iceberg_namespace\nWHERE namespace_id = :namespace_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_DETAILS_ALL = "SELECT\n    namespace_id,\n    namespace_name,\n    catalog_id,\n    properties\nFROM metastore_iceberg_namespace\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_LIST = "SELECT\n    namespace_id,\n    namespace_name\nFROM metastore_iceberg_namespace\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_LIST_FOR_API = "SELECT\n    c.catalog_name,\n    n.namespace_id,\n    n.namespace_name,\n    n.properties\nFROM metastore_iceberg_namespace n\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_INFO = "SELECT\n    c.catalog_name,\n    n.namespace_name,\n    t.table_name,\n    t.table_type,\n    t.metadata_location,\n    t.previous_metadata_location,\n    t.mv\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\nWHERE table_name = :table_name AND namespace_name = :namespace_name AND catalog_name = :catalog_name\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_ID = "SELECT\n    table_id\nFROM metastore_iceberg_table\nWHERE namespace_id = :namespace_id AND table_name = :table_name\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_METADATA_LOCATION = "SELECT\n    metadata_location\nFROM metastore_iceberg_table\nWHERE namespace_id = :namespace_id AND table_name = :table_name AND table_type = :table_type\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_LIST = "SELECT\n    table_id,\n    table_name\nFROM metastore_iceberg_table\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_LIST_FOR_API = "SELECT\n    c.catalog_name,\n    n.namespace_name,\n    t.table_id,\n    t.table_name,\n    t.table_type,\n    t.metadata_location,\n    t.previous_metadata_location,\n    t.mv\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_CREATE = "INSERT INTO metastore_iceberg_table (\n    table_id,\n    table_name,\n    table_type,\n    namespace_id,\n    metadata_location,\n    mv)\nVALUES (\n    :table_id,\n    :table_name,\n    :table_type,\n    :namespace_id,\n    :metadata_location,\n    :mv)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_UPDATE = "UPDATE metastore_iceberg_table\nSET\n    metadata_location = :metadata_location,\n    previous_metadata_location = :previous_metadata_location\nWHERE namespace_id = :namespace_id AND table_name = :table_name AND table_type = :table_type AND metadata_location = :previous_metadata_location\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_RENAME = "UPDATE metastore_iceberg_table\nSET\n    namespace_id = :new_namespace_id,\n    table_name = :new_table_name\nWHERE namespace_id = :namespace_id AND table_name = :table_name AND table_type = :table_type\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_DELETE = "DELETE FROM metastore_iceberg_table\nWHERE namespace_id = :namespace_id AND table_name = :table_name AND table_type = :table_type\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_MV_SNAPSHOT_DELETE = "DELETE FROM metastore_iceberg_table_mv_snapshot\nWHERE table_id = :table_id";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_MV_SNAPSHOT_CREATE = "INSERT INTO metastore_iceberg_table_mv_snapshot (\n    table_id,\n    snapshot_id,\n    plan)\nVALUES (\n    :table_id,\n    :snapshot_id,\n    :plan)";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_TABLE_MV_SNAPSHOT_REFERENCED_TABLE_CREATE = "INSERT INTO metastore_iceberg_table_mv_snapshot_referenced_table (\n    table_id,\n    snapshot_id,\n    referenced_table_name)\nVALUES (\n    :table_id,\n    :snapshot_id,\n    :referenced_table_name)";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_MATERIALIZED_VIEWS_FOR_REWRITE = "SELECT\n    n.namespace_name,\n    t.table_name,\n    mv_s.plan,\n    mv_s.snapshot_id\nFROM metastore_iceberg_table t\n    INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    INNER JOIN metastore_iceberg_table_mv_snapshot mv_s ON t.table_id = mv_s.table_id\n    INNER JOIN metastore_iceberg_table_mv_snapshot_referenced_table mv_srt ON mv_s.table_id = mv_srt.table_id AND mv_s.snapshot_id = mv_srt.snapshot_id\nWHERE\n    c.catalog_name = :catalog_name AND t.mv = 1 AND mv_srt.referenced_table_name IN ({referenced_table_names})\n";
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final JdbcCatalogStoreAccessor accessor;
    private final PageProcessorFactory<PrincipalInfoWithId> principalListPageProcessorFactory;
    private final PageProcessorFactory<AccessTokenInfo> accessTokenListPageProcessorFactory;
    private final PageProcessorFactory<AccessTokenInfo> accessTokenListForPrincipalPageProcessorFactory;
    private final PageProcessorFactory<FileSystemInfoWithId> fileSystemListPageProcessorFactory;
    private final PageProcessorFactory<IcebergCatalogInfoWithId> icebergCatalogListPageProcessorFactory;
    private final PageProcessorFactory<IcebergNamespaceNameWithId> icebergNamespaceListPageProcessorFactory;
    private final PageProcessorFactory<IcebergNamespaceInfoWithId> icebergNamespaceListForApiPageProcessorFactory;
    private final PageProcessorFactory<IcebergTableNameWithId> icebergTableListPageProcessorFactory;
    private final PageProcessorFactory<IcebergTableInfoWithId> icebergTableListForApiPageProcessorFactory;

    public AbstractJdbcCatalogStore(JdbcCatalogStoreAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        int maxPageSize = config.getStoreMaxPageSize();
        this.principalListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_PRINCIPAL_LIST, "u.principal_id"), maxPageSize, PageProcessorPageTokenConverter.AS_UUID, PrincipalInfoWithId::id);
        this.accessTokenListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder("SELECT\n    at.access_token_id,\n    u.principal_name,\n    at.description\nFROM metastore_access_token at\n    INNER JOIN metastore_principal u ON at.principal_id = u.principal_id\n", "at.access_token_id"), maxPageSize, PageProcessorPageTokenConverter.AS_VARCHAR, AccessTokenInfo::getAccessTokenId);
        this.accessTokenListForPrincipalPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder("SELECT\n    at.access_token_id,\n    u.principal_name,\n    at.description\nFROM metastore_access_token at\n    INNER JOIN metastore_principal u ON at.principal_id = u.principal_id\n", "at.access_token_id"), maxPageSize, PageProcessorPageTokenConverter.AS_VARCHAR, AccessTokenInfo::getAccessTokenId);
        this.fileSystemListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder("SELECT\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    description,\n    properties\nFROM metastore_file_system\n", "file_system_id"), maxPageSize, PageProcessorPageTokenConverter.AS_UUID, FileSystemInfoWithId::id);
        this.icebergCatalogListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_CATALOG_LIST, "c.catalog_id"), maxPageSize, PageProcessorPageTokenConverter.AS_UUID, IcebergCatalogInfoWithId::id);
        this.icebergNamespaceListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_NAMESPACE_LIST, "namespace_id"), maxPageSize, PageProcessorPageTokenConverter.AS_UUID, IcebergNamespaceNameWithId::id);
        this.icebergNamespaceListForApiPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_NAMESPACE_LIST_FOR_API, "n.namespace_id"), maxPageSize, PageProcessorPageTokenConverter.AS_UUID, IcebergNamespaceInfoWithId::id);
        this.icebergTableListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_TABLE_LIST, "table_id"), maxPageSize, PageProcessorPageTokenConverter.AS_UUID, IcebergTableNameWithId::id);
        this.icebergTableListForApiPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_TABLE_LIST_FOR_API, "t.table_id"), maxPageSize, PageProcessorPageTokenConverter.AS_UUID, IcebergTableInfoWithId::id);
    }

    @Override
    @PostConstruct
    public void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            this.accessor.migrate();
        }
    }

    @Override
    public Optional<UUID> createPrincipalIfNotExists(String principalName, PrincipalType principalType, String hashedPassword, Map<UUID, String> roles, boolean active, Map<String, String> properties) {
        UUID principalId = UUID.randomUUID();
        return this.accessor.execute(handle -> (Optional)handle.inTransaction(txHandle -> {
            boolean created;
            boolean bl = created = ((Update)((Update)((Update)((Update)((Update)((Update)txHandle.createUpdate(SQL_PRINCIPAL_CREATE).bind("principal_id", principalId)).bind("principal_name", principalName)).bind("principal_type", principalType.getValue())).bind("hashed_password", hashedPassword)).bind("active", (short)(active ? 1 : 0))).bind("properties", AbstractJdbcCatalogStore.propertiesToString(properties))).execute() == 1;
            if (created) {
                for (Map.Entry role : roles.entrySet()) {
                    this.grantRoleInTransaction(txHandle, principalName, principalId, (UUID)role.getKey(), (String)role.getValue());
                }
            }
            return created ? Optional.of(principalId) : Optional.empty();
        }));
    }

    @Override
    public boolean updatePrincipalIfExists(UUID principalId, String newPrincipalName, boolean newActive, Map<String, String> newProperties, Optional<String> newHashedPassword) {
        StringJoiner sqlJoiner = new StringJoiner(",\n");
        sqlJoiner.add("principal_name = :principal_name");
        sqlJoiner.add("active = :active");
        sqlJoiner.add("properties = :properties");
        if (newHashedPassword.isPresent()) {
            sqlJoiner.add("hashed_password = :hashed_password");
        }
        String sql = String.format(SQL_PRINCIPAL_UPDATE_TEMPLATE, sqlJoiner);
        try {
            return this.accessor.execute(handle -> {
                Update update = handle.createUpdate(sql);
                update.bind("principal_id", principalId);
                update.bind("principal_name", newPrincipalName);
                update.bind("active", (short)(newActive ? 1 : 0));
                update.bind("properties", AbstractJdbcCatalogStore.propertiesToString(newProperties));
                if (newHashedPassword.isPresent()) {
                    update.bind("hashed_password", (String)newHashedPassword.get());
                }
                return update.execute() == 1;
            });
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new CatalogPrincipalAlreadyExistsException(newPrincipalName);
            }
            throw e;
        }
    }

    @Override
    public boolean deletePrincipalIfExists(UUID principalId, String principalName) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_PRINCIPAL_DELETE).bind("principal_id", principalId)).execute() == 1);
        }
        catch (Throwable e) {
            if (this.isConstraintViolationException(e)) {
                throw new CatalogPrincipalInUseException(principalName);
            }
            throw e;
        }
    }

    @Override
    public Optional<UUID> getPrincipalIdByName(String principalName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_ID).bind("principal_name", principalName)).map((rs, ctx) -> this.getUuid(rs, "principal_id")).findOne());
    }

    @Override
    public Optional<PrincipalDetails> getPrincipalDetailsByName(String principalName, boolean readPassword) {
        if (readPassword) {
            return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_DETAILS_WITH_PASSWORD).bind("principal_name", principalName)).map((rs, ctx) -> new PrincipalDetails(this.getUuid(rs, "principal_id"), rs.getString("principal_name"), AbstractJdbcCatalogStore.principalTypeFromShort(rs.getShort("principal_type")), rs.getShort("active") == 1, Optional.ofNullable(rs.getString("hashed_password")), AbstractJdbcCatalogStore.parseRoleIds(rs.getString("role_ids")), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties")))).findOne());
        }
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_DETAILS_WITHOUT_PASSWORD).bind("principal_name", principalName)).map((rs, ctx) -> new PrincipalDetails(this.getUuid(rs, "principal_id"), rs.getString("principal_name"), AbstractJdbcCatalogStore.principalTypeFromShort(rs.getShort("principal_type")), rs.getShort("active") == 1, Optional.empty(), AbstractJdbcCatalogStore.parseRoleIds(rs.getString("role_ids")), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties")))).findOne());
    }

    @Override
    public Optional<PrincipalDetails> getPrincipalDetailsByAccessTokenId(String accessTokenId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_DETAILS_BY_ACCESS_TOKEN_ID).bind("access_token_id", accessTokenId)).map((rs, ctx) -> new PrincipalDetails(this.getUuid(rs, "principal_id"), rs.getString("principal_name"), AbstractJdbcCatalogStore.principalTypeFromShort(rs.getShort("principal_type")), rs.getShort("active") == 1, Optional.of(rs.getString("hashed_access_token")), AbstractJdbcCatalogStore.parseRoleIds(rs.getString("role_ids")), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties")))).findOne());
    }

    private static PrincipalType principalTypeFromShort(short value) {
        return PrincipalType.resolveFromShort(value);
    }

    private static PrincipalType principalTypeFromString(String principalType) {
        return PrincipalType.resolveFromString(principalType).orElseThrow(() -> new IllegalArgumentException("Unsupported principal type: " + principalType));
    }

    private static Set<UUID> parseRoleIds(String value) {
        if (value == null) {
            return Set.of();
        }
        String[] tokens = value.split(",");
        HashSet<UUID> result = HashSet.newHashSet(tokens.length);
        for (String token : tokens) {
            result.add(UUID.fromString(token));
        }
        return result;
    }

    @Override
    public Optional<PrincipalInfo> getPrincipal(String principalName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_PRINCIPAL_INFO).bind("principal_name", principalName)).map((rs, ctx) -> AbstractJdbcCatalogStore.toPrincipalInfo(rs)).findOne());
    }

    @Override
    public Map<String, PrincipalIdAndType> getPrincipalIdAndType(Collection<String> principalNames) {
        record PrincipalIdNameAndType(UUID id, String name, PrincipalType type) {
        }
        if (principalNames.isEmpty()) {
            return Map.of();
        }
        List list = this.accessor.execute(handle -> {
            String sql = SQL_PRINCIPAL_ID_AND_TYPE.replace("{referenced_principal_names}", principalNames.stream().map(name -> "?").collect(Collectors.joining(", ")));
            Query query = handle.createQuery(sql);
            int i = 0;
            for (String principalName : principalNames) {
                query.bind(i++, principalName);
            }
            return query.map((rs, ctx) -> new PrincipalIdNameAndType(this.getUuid(rs, "principal_id"), rs.getString("principal_name"), AbstractJdbcCatalogStore.principalTypeFromShort(rs.getShort("principal_type")))).list();
        });
        if (list.isEmpty()) {
            return Map.of();
        }
        HashMap<String, PrincipalIdAndType> res = HashMap.newHashMap(list.size());
        for (PrincipalIdNameAndType entry : list) {
            res.put(entry.name(), new PrincipalIdAndType(entry.id(), entry.type));
        }
        return res;
    }

    @Override
    public PrincipalListResponse listPrincipals(Optional<String> principalType, ResultPage page) {
        PageProcessor<PrincipalInfoWithId> pageSelector = this.principalListPageProcessorFactory.create(page);
        List items = this.accessor.execute(handle -> {
            List<String> conditions = principalType.isPresent() ? List.of("u.principal_type = :principal_type") : List.of();
            Map<String, Object> bindings = principalType.isPresent() ? Map.of("principal_type", AbstractJdbcCatalogStore.principalTypeFromString((String)principalType.get()).getValue()) : Map.of();
            return pageSelector.createQuery((Handle)handle, conditions, bindings).map((rs, ctx) -> new PrincipalInfoWithId(this.getUuid(rs, "principal_id"), AbstractJdbcCatalogStore.toPrincipalInfo(rs))).list();
        });
        return new PrincipalListResponse(items.stream().map(PrincipalInfoWithId::info).toList(), pageSelector.nextPageToken(items));
    }

    private static PrincipalInfo toPrincipalInfo(ResultSet rs) throws SQLException {
        return new PrincipalInfo(rs.getString("principal_name"), AbstractJdbcCatalogStore.principalTypeFromShort(rs.getShort("principal_type")).getCaption(), Boolean.valueOf(rs.getShort("active") == 1), AbstractJdbcCatalogStore.parseRoleNames(rs.getString("role_names")), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties")));
    }

    private static Set<String> parseRoleNames(String value) {
        if (value == null) {
            return Set.of();
        }
        String[] tokens = value.split(",");
        return new HashSet<String>(Arrays.asList(tokens));
    }

    @Override
    public long countUserPrincipals() {
        return this.accessor.execute(handle -> (Long)handle.createQuery(SQL_PRINCIPAL_USER_COUNT).map((rs, ctx) -> rs.getLong(1)).one());
    }

    @Override
    public void createAccessToken(UUID principalId, String principalName, String accessTokenId, String hashAccessToken, String description) {
        try {
            this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ACCESS_TOKEN_CREATE).bind("access_token_id", accessTokenId)).bind("hashed_access_token", hashAccessToken)).bind("principal_id", principalId)).bind("description", description)).execute());
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new CatalogPrincipalDoesNotExistException(principalName);
            }
            throw e;
        }
    }

    @Override
    public boolean deleteAccessTokenIfExists(String accessTokenId) {
        return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_ACCESS_TOKEN_DELETE).bind("access_token_id", accessTokenId)).execute() == 1);
    }

    @Override
    public AccessTokenListResponse listAccessTokens(ResultPage page) {
        PageProcessor<AccessTokenInfo> pageProcessor = this.accessTokenListPageProcessorFactory.create(page);
        List results = this.accessor.execute(handle -> pageProcessor.createQuery((Handle)handle).map((rs, ctx) -> new AccessTokenInfo(rs.getString("access_token_id"), rs.getString("principal_name"), rs.getString("description"))).list());
        return new AccessTokenListResponse(results, pageProcessor.nextPageToken(results));
    }

    @Override
    public AccessTokenListResponse listPrincipalAccessTokens(UUID principalId, ResultPage page) {
        PageProcessor<AccessTokenInfo> pageProcessor = this.accessTokenListForPrincipalPageProcessorFactory.create(page);
        List results = this.accessor.execute(handle -> pageProcessor.createQuery((Handle)handle, List.of("at.principal_id = :principal_id"), Map.of("principal_id", principalId)).map((rs, ctx) -> new AccessTokenInfo(rs.getString("access_token_id"), rs.getString("principal_name"), rs.getString("description"))).list());
        return new AccessTokenListResponse(results, pageProcessor.nextPageToken(results));
    }

    @Override
    public List<String> listPrincipalAccessTokenIds(UUID principalId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_ACCESS_TOKEN_ID_LIST).bind("principal_id", principalId)).map((rs, ctx) -> rs.getString("access_token_id")).list());
    }

    @Override
    public Map<String, UUID> listRoles() {
        record RoleIdAndName(UUID id, String name) {
        }
        List roles = this.accessor.execute(handle -> handle.createQuery(SQL_ROLE_LIST).map((rs, ctx) -> new RoleIdAndName(this.getUuid(rs, "principal_id"), rs.getString("principal_name"))).list());
        HashMap<String, UUID> res = HashMap.newHashMap(roles.size());
        for (RoleIdAndName role : roles) {
            res.put(role.name(), role.id());
        }
        return res;
    }

    @Override
    public boolean grantRoleIfNotGranted(UUID principalId, String principalName, UUID roleId, String roleName) {
        return this.accessor.execute(handle -> (Boolean)handle.inTransaction(txHandle -> this.grantRoleInTransaction(txHandle, principalName, principalId, roleId, roleName)));
    }

    private boolean grantRoleInTransaction(Handle txHandle, String principalName, UUID principalId, UUID roleId, String roleName) {
        Verify.verify((boolean)txHandle.isInTransaction());
        this.lockPrincipal(txHandle, principalName, principalId);
        Optional<List<String>> loop = this.checkRoleLoop(txHandle, principalName, principalId, roleId);
        if (loop.isPresent()) {
            throw new NestedStoreException((RuntimeException)new CatalogRecursiveRoleGrantException(principalName, roleName, loop.get()));
        }
        return ((Update)((Update)txHandle.createUpdate(SQL_ROLE_GRANT).bind("principal_id", principalId)).bind("role_id", roleId)).execute() == 1;
    }

    private Optional<List<String>> checkRoleLoop(Handle txHandle, String principalName, UUID principalId, UUID roleId) {
        Verify.verify((boolean)txHandle.isInTransaction());
        if (principalId.equals(roleId)) {
            return Optional.of(List.of(principalName, principalName));
        }
        ArrayList<RoleLink> links = new ArrayList<RoleLink>();
        HashSet<UUID> allRoleIds = new HashSet<UUID>();
        allRoleIds.add(roleId);
        Set<UUID> roleIdsToCheck = Set.of(roleId);
        while (!roleIdsToCheck.isEmpty()) {
            String sql = SQL_PRINCIPAL_ROLES.replace("{referenced_role_ids}", roleIdsToCheck.stream().map(r -> "?").collect(Collectors.joining(", ")));
            Query query = txHandle.createQuery(sql);
            int i = 0;
            for (UUID id : roleIdsToCheck) {
                query.bind(i, id);
            }
            List newLinks = query.map((rs, ctx) -> new RoleLink(this.getUuid(rs, "principal_id"), this.getUuid(rs, "role_id"))).list();
            HashSet<UUID> newRoleIdsToCheck = new HashSet<UUID>();
            for (RoleLink link : newLinks) {
                links.add(link);
                if (principalId.equals(link.toId())) {
                    return Optional.of(this.buildRoleChain(txHandle, principalId, roleId, links));
                }
                if (!allRoleIds.add(link.toId())) continue;
                newRoleIdsToCheck.add(link.toId());
            }
            roleIdsToCheck = newRoleIdsToCheck;
        }
        return Optional.empty();
    }

    private List<String> buildRoleChain(Handle txHandle, UUID principalId, UUID roleId, List<RoleLink> links) {
        record RoleWithName(UUID id, String name) {
        }
        HashMap<UUID, Set<UUID>> roleGraph = new HashMap<UUID, Set<UUID>>();
        for (RoleLink entry : links) {
            roleGraph.computeIfAbsent(entry.fromId(), k -> new HashSet()).add(entry.toId());
        }
        List<UUID> roleChain = this.buildRoleIdChain(roleGraph, roleId, principalId);
        String sql = SQL_PRINCIPAL_NAMES.replace("{referenced_role_ids}", roleChain.stream().map(id -> "?").collect(Collectors.joining(", ")));
        Query query = txHandle.createQuery(sql);
        for (int i = 0; i < roleChain.size(); ++i) {
            query.bind(i, roleChain.get(i));
        }
        List roleNames = query.map((rs, ctx) -> new RoleWithName(this.getUuid(rs, "principal_id"), rs.getString("principal_name"))).list();
        HashMap<UUID, String> roleIdToName = HashMap.newHashMap(roleNames.size());
        for (RoleWithName entry : roleNames) {
            roleIdToName.put(entry.id(), entry.name());
        }
        ArrayList<String> res = new ArrayList<String>(roleChain.size() + 1);
        for (UUID currentRoleId : roleChain) {
            String currentRoleName = (String)roleIdToName.get(currentRoleId);
            if (currentRoleName == null) {
                currentRoleName = "<dropped>";
            }
            res.add(currentRoleName);
        }
        res.add((String)res.get(0));
        return res;
    }

    private List<UUID> buildRoleIdChain(Map<UUID, Set<UUID>> graph, UUID startRoleId, UUID endRoleId) {
        ArrayList<UUID> res = new ArrayList<UUID>();
        this.buildRoleIdChain(graph, startRoleId, endRoleId, new ArrayList<UUID>(), res);
        Verify.verify((!res.isEmpty() ? 1 : 0) != 0);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRoleIdChain(Map<UUID, Set<UUID>> graph, UUID roleId, UUID endRoleId, List<UUID> rolesSoFar, List<UUID> res) {
        if (!res.isEmpty()) {
            return;
        }
        rolesSoFar.add(roleId);
        try {
            if (roleId.equals(endRoleId)) {
                res.addAll(rolesSoFar);
                return;
            }
            for (UUID childRoleId : graph.getOrDefault(roleId, Set.of())) {
                this.buildRoleIdChain(graph, childRoleId, endRoleId, rolesSoFar, res);
            }
        }
        finally {
            rolesSoFar.removeLast();
        }
    }

    private void lockPrincipal(Handle txHandle, String principalName, UUID principalId) {
        Verify.verify((boolean)txHandle.isInTransaction());
        boolean present = ((Query)txHandle.createQuery(this.forUpdate(SQL_PRINCIPAL_FOR_UPDATE)).bind("principal_id", principalId)).map((rs, ctx) -> this.getUuid(rs, "principal_id")).findOne().isPresent();
        if (!present) {
            throw new CatalogPrincipalDoesNotExistException(principalName);
        }
    }

    @Override
    public boolean revokeRoleIfGranted(UUID principalId, UUID roleId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_ROLE_REVOKE).bind("principal_id", principalId)).bind("role_id", roleId)).execute() == 1);
    }

    @Override
    public boolean createFileSystemIfNotExists(UUID id, String name, String description, CatalogFileSystemType type, Map<String, String> properties) {
        return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_FILE_SYSTEM_CREATE).bind("file_system_id", id)).bind("file_system_name", name)).bind("file_system_type", type.name())).bind("description", description)).bind("properties", AbstractJdbcCatalogStore.propertiesToString(properties))).execute() == 1);
    }

    @Override
    public boolean updateFileSystemIfExists(UUID id, String name, String description, Map<String, String> properties) {
        try {
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_FILE_SYSTEM_UPDATE).bind("file_system_id", id)).bind("file_system_name", name)).bind("description", description)).bind("properties", AbstractJdbcCatalogStore.propertiesToString(properties))).execute() == 1);
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new CatalogFileSystemAlreadyExistsException(name);
            }
            throw e;
        }
    }

    @Override
    public boolean deleteFileSystemIfExists(UUID id, String name) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_FILE_SYSTEM_DELETE).bind("file_system_id", id)).execute() == 1);
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new CatalogFileSystemInUseException(name);
            }
            throw e;
        }
    }

    @Override
    public Optional<FileSystemDetails> fileSystemDetails(String name) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_FILE_SYSTEM_DETAILS).bind("file_system_name", name)).map((rs, ctx) -> this.toFileSystemDetails(rs)).findOne());
    }

    @Override
    public List<FileSystemDetails> fileSystemAllDetails() {
        return this.accessor.execute(handle -> handle.createQuery("SELECT\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    description,\n    properties\nFROM metastore_file_system\n").map((rs, ctx) -> this.toFileSystemDetails(rs)).list());
    }

    private FileSystemDetails toFileSystemDetails(ResultSet rs) throws SQLException {
        return new FileSystemDetails(this.getUuid(rs, "file_system_id"), rs.getString("file_system_name"), rs.getString("description"), CatalogUtils.resolveFileSystemType(rs.getString("file_system_type")), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties")));
    }

    @Override
    public Optional<FileSystemInfo> getFileSystem(String name) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_FILE_SYSTEM_INFO).bind("file_system_name", name)).map((rs, ctx) -> this.toFileSystemInfo(rs)).findOne()).map(FileSystemInfoWithId::info);
    }

    @Override
    public FileSystemListResponse listFileSystems(ResultPage page) {
        PageProcessor<FileSystemInfoWithId> pageProcessor = this.fileSystemListPageProcessorFactory.create(page);
        List results = this.accessor.execute(handle -> pageProcessor.createQuery((Handle)handle).map((rs, ctx) -> this.toFileSystemInfo(rs)).list());
        return new FileSystemListResponse(results.stream().map(FileSystemInfoWithId::info).toList(), pageProcessor.nextPageToken(results));
    }

    private FileSystemInfoWithId toFileSystemInfo(ResultSet rs) throws SQLException {
        return new FileSystemInfoWithId(this.getUuid(rs, "file_system_id"), new FileSystemInfo(rs.getString("file_system_name"), rs.getString("file_system_type"), rs.getString("description"), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties"))));
    }

    @Override
    public Optional<UUID> createIcebergCatalogIfNotExists(String catalogName, String description, UUID fileSystemId, String fileSystemName, String fileSystemLocation, Map<String, String> properties) {
        try {
            UUID catalogId = UUID.randomUUID();
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_CATALOG_CREATE).bind("catalog_id", catalogId)).bind("catalog_name", catalogName)).bind("description", description)).bind("file_system_id", fileSystemId)).bind("file_system_location", fileSystemLocation)).bind("properties", AbstractJdbcCatalogStore.propertiesToString(properties))).execute() == 1 ? Optional.of(catalogId) : Optional.empty());
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new CatalogFileSystemDoesNotExistException(fileSystemName);
            }
            throw e;
        }
    }

    @Override
    public boolean updateIcebergCatalogIfExists(UUID catalogId, String catalogName, String description, String fileSystemLocation, Map<String, String> properties) {
        try {
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_CATALOG_UPDATE).bind("catalog_id", catalogId)).bind("catalog_name", catalogName)).bind("description", description)).bind("file_system_location", fileSystemLocation)).bind("properties", AbstractJdbcCatalogStore.propertiesToString(properties))).execute() == 1);
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new IcebergCatalogAlreadyExistsException(catalogName);
            }
            throw e;
        }
    }

    @Override
    public boolean deleteIcebergCatalogIfExists(UUID catalogId, String catalogName) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_ICEBERG_CATALOG_DELETE).bind("catalog_id", catalogId)).execute() == 1);
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new IcebergCatalogInUseException(catalogName);
            }
            throw e;
        }
    }

    @Override
    public List<IcebergCatalogDetails> listIcebergCatalogDetails() {
        return this.accessor.execute(handle -> handle.createQuery(SQL_ICEBERG_CATALOG_INFO_ALL).map((rs, ctx) -> this.toIcebergCatalogDetails(rs)).list());
    }

    private IcebergCatalogDetails toIcebergCatalogDetails(ResultSet rs) throws SQLException {
        return new IcebergCatalogDetails(this.getUuid(rs, "catalog_id"), rs.getString("catalog_name"), rs.getString("description"), this.getUuid(rs, "file_system_id"), rs.getString("file_system_location"), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties")));
    }

    @Override
    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage page) {
        PageProcessor<IcebergCatalogInfoWithId> pageProcessor = this.icebergCatalogListPageProcessorFactory.create(page);
        List results = this.accessor.execute(handle -> pageProcessor.createQuery((Handle)handle).map((rs, ctx) -> new IcebergCatalogInfoWithId(this.getUuid(rs, "catalog_id"), new IcebergCatalogInfo(rs.getString("catalog_name"), rs.getString("description"), rs.getString("file_system_name"), rs.getString("file_system_location"), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties"))))).list());
        return new IcebergCatalogListResponse(results.stream().map(IcebergCatalogInfoWithId::info).toList(), pageProcessor.nextPageToken(results));
    }

    @Override
    public Optional<UUID> createIcebergNamespaceIfNotExists(String namespaceName, UUID catalogId, String catalogName, Map<String, String> properties) {
        try {
            UUID namespaceId = UUID.randomUUID();
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_NAMESPACE_CREATE).bind("namespace_id", namespaceId)).bind("namespace_name", namespaceName)).bind("catalog_id", catalogId)).bind("properties", AbstractJdbcCatalogStore.propertiesToString(properties))).execute() == 1 ? Optional.of(namespaceId) : Optional.empty());
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new IcebergCatalogDoesNotExistException(catalogName);
            }
            throw e;
        }
    }

    @Override
    public boolean updateIcebergNamespaceIfExists(UUID namespaceId, Map<String, String> properties) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_ICEBERG_NAMESPACE_UPDATE).bind("namespace_id", namespaceId)).bind("properties", AbstractJdbcCatalogStore.propertiesToString(properties))).execute() == 1);
    }

    @Override
    public boolean deleteIcebergNamespaceIfExists(UUID namespaceId, String namespaceName, String catalogName) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_ICEBERG_NAMESPACE_DELETE).bind("namespace_id", namespaceId)).execute() == 1);
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new IcebergNamespaceNotEmptyException(namespaceName);
            }
            throw e;
        }
    }

    @Override
    public List<IcebergNamespaceDetails> listIcebergNamespaceDetails() {
        return this.accessor.execute(handle -> handle.createQuery(SQL_ICEBERG_NAMESPACE_DETAILS_ALL).map((rs, ctx) -> this.toNamespaceInfo(rs)).list());
    }

    @Override
    public IcebergNamespaceListResponse listIcebergNamespacesForApi(Optional<String> catalogName, ResultPage page) {
        ArrayList<String> conditions = new ArrayList<String>();
        HashMap<String, String> bindings = new HashMap<String, String>();
        if (catalogName.isPresent()) {
            conditions.add("c.catalog_name = :catalog_name");
            bindings.put("catalog_name", catalogName.get());
        }
        PageProcessor<IcebergNamespaceInfoWithId> pageProcessor = this.icebergNamespaceListForApiPageProcessorFactory.create(page);
        List items = this.accessor.execute(handle -> pageProcessor.createQuery((Handle)handle, (List<String>)conditions, (Map<String, Object>)bindings).map((rs, ctx) -> new IcebergNamespaceInfoWithId(this.getUuid(rs, "namespace_id"), new IcebergNamespaceInfo(rs.getString("catalog_name"), rs.getString("namespace_name"), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties"))))).list());
        return new IcebergNamespaceListResponse(items.stream().map(IcebergNamespaceInfoWithId::info).toList(), pageProcessor.nextPageToken(items));
    }

    @Override
    public IcebergNamespaceListResult listIcebergNamespaces(UUID catalogId, ResultPage page) {
        PageProcessor<IcebergNamespaceNameWithId> pageProcessor = this.icebergNamespaceListPageProcessorFactory.create(page);
        List items = this.accessor.execute(handle -> pageProcessor.createQuery((Handle)handle, List.of("catalog_id = :catalog_id"), Map.of("catalog_id", catalogId)).map((rs, ctx) -> new IcebergNamespaceNameWithId(this.getUuid(rs, "namespace_id"), rs.getString("namespace_name"))).list());
        return new IcebergNamespaceListResult(items.stream().map(IcebergNamespaceNameWithId::name).toList(), pageProcessor.nextPageToken(items));
    }

    private IcebergNamespaceDetails toNamespaceInfo(ResultSet rs) throws SQLException {
        return new IcebergNamespaceDetails(this.getUuid(rs, "namespace_id"), rs.getString("namespace_name"), this.getUuid(rs, "catalog_id"), AbstractJdbcCatalogStore.stringToProperties(rs.getString("properties")));
    }

    @Override
    public Optional<String> getIcebergTableMetadataLocation(String catalogName, String namespaceName, UUID namespaceId, String tableName, IcebergTableType tableType) {
        List values = this.accessor.execute(handle -> ((Query)((Query)((Query)handle.createQuery(SQL_ICEBERG_TABLE_METADATA_LOCATION).bind("namespace_id", namespaceId)).bind("table_name", tableName)).bind("table_type", tableType.getIdentifier())).map((rs, ctx) -> rs.getString("metadata_location")).list());
        return values.isEmpty() ? Optional.empty() : Optional.ofNullable((String)values.get(0));
    }

    @Override
    public boolean createIcebergTableIfNotExist(UUID namespaceId, String tableName, IcebergTableType tableType, String metadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails) {
        UUID tableId = UUID.randomUUID();
        return this.accessor.execute(handle -> (Boolean)handle.inTransaction(txHandle -> {
            int updateCount = ((Update)((Update)((Update)((Update)((Update)((Update)txHandle.createUpdate(SQL_ICEBERG_TABLE_CREATE).bind("table_id", tableId)).bind("table_name", tableName)).bind("table_type", tableType.getIdentifier())).bind("namespace_id", namespaceId)).bind("metadata_location", metadataLocation)).bind("mv", materializedViewDetails.isPresent() ? 1 : 0)).execute();
            if (updateCount == 0) {
                return false;
            }
            if (materializedViewDetails.isPresent()) {
                this.updateMaterializedView(txHandle, tableId, (IcebergMaterializedViewDetails)materializedViewDetails.get(), false);
            }
            return true;
        }));
    }

    @Override
    public boolean updateIcebergTableIfExists(UUID namespaceId, String tableName, IcebergTableType tableType, String metadataLocation, String previousMetadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails) {
        return this.accessor.execute(handle -> (Boolean)handle.inTransaction(txHandle -> {
            int updateCount = ((Update)((Update)((Update)((Update)((Update)txHandle.createUpdate(SQL_ICEBERG_TABLE_UPDATE).bind("namespace_id", namespaceId)).bind("table_name", tableName)).bind("table_type", tableType.getIdentifier())).bind("metadata_location", metadataLocation)).bind("previous_metadata_location", previousMetadataLocation)).execute();
            if (updateCount != 1) {
                return false;
            }
            if (materializedViewDetails.isPresent()) {
                UUID tableId = (UUID)((Query)((Query)txHandle.createQuery(SQL_ICEBERG_TABLE_ID).bind("namespace_id", namespaceId)).bind("table_name", tableName)).map((rs, ctx) -> this.getUuid(rs, "table_id")).one();
                this.updateMaterializedView(txHandle, tableId, (IcebergMaterializedViewDetails)materializedViewDetails.get(), true);
            }
            return true;
        }));
    }

    private void updateMaterializedView(Handle handle, UUID tableId, IcebergMaterializedViewDetails mv, boolean delete) {
        if (delete) {
            ((Update)handle.createUpdate(SQL_ICEBERG_TABLE_MV_SNAPSHOT_DELETE).bind("table_id", tableId)).execute();
        }
        if (mv.snapshot().isPresent()) {
            IcebergMaterializedViewSnapshotDetails mvSnapshot = mv.snapshot().get();
            ((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_MV_SNAPSHOT_CREATE).bind("table_id", tableId)).bind("snapshot_id", mvSnapshot.snapshotId())).bind("plan", mvSnapshot.plan())).execute();
            if (!mvSnapshot.referencedTables().isEmpty()) {
                PreparedBatch batch = handle.prepareBatch(SQL_ICEBERG_TABLE_MV_SNAPSHOT_REFERENCED_TABLE_CREATE);
                for (String referencedTable : mvSnapshot.referencedTables()) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("table_id", tableId)).bind("snapshot_id", mvSnapshot.snapshotId())).bind("referenced_table_name", referencedTable)).add();
                }
                batch.execute();
            }
        }
    }

    @Override
    public boolean renameIcebergTableIfExists(String catalogName, UUID fromNamespaceId, String fromTableName, String toNamespaceName, UUID toNamespaceId, String toTableName, IcebergTableType tableType) {
        try {
            return this.accessor.execute(handle -> {
                int updateCount = ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_RENAME).bind("namespace_id", fromNamespaceId)).bind("table_name", fromTableName)).bind("new_namespace_id", toNamespaceId)).bind("new_table_name", toTableName)).bind("table_type", tableType.getIdentifier())).execute();
                return updateCount == 1;
            });
        }
        catch (Exception e) {
            if (this.isConstraintViolationException(e)) {
                throw new IcebergObjectAlreadyExistsException(toNamespaceName, toTableName);
            }
            throw e;
        }
    }

    @Override
    public boolean deleteIcebergTableIfExists(UUID namespaceId, String tableName, IcebergTableType tableType) {
        return this.accessor.execute(handle -> {
            int updateCount = ((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_TABLE_DELETE).bind("namespace_id", namespaceId)).bind("table_name", tableName)).bind("table_type", tableType.getIdentifier())).execute();
            return updateCount == 1;
        });
    }

    @Override
    public IcebergTableListResult listIcebergTables(UUID namespaceId, IcebergTableType type, ResultPage page) {
        PageProcessor<IcebergTableNameWithId> pageProcessor = this.icebergTableListPageProcessorFactory.create(page);
        List results = this.accessor.execute(handle -> {
            List<String> conditions = List.of("namespace_id = :namespace_id", "table_type = :table_type", "mv = 0");
            Map<String, Object> bindings = Map.of("namespace_id", namespaceId, "table_type", type.getIdentifier());
            return pageProcessor.createQuery((Handle)handle, conditions, bindings).map((rs, ctx) -> new IcebergTableNameWithId(this.getUuid(rs, "table_id"), rs.getString("table_name"))).list();
        });
        return new IcebergTableListResult(results.stream().map(IcebergTableNameWithId::name).toList(), pageProcessor.nextPageToken(results));
    }

    @Override
    public IcebergObjectListResponse listIcebergObjectsForApi(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        ArrayList<String> conditions = new ArrayList<String>();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        if (catalogName.isPresent()) {
            conditions.add("c.catalog_name = :catalog_name");
            bindings.put("catalog_name", catalogName.get());
        }
        if (namespaceName.isPresent()) {
            conditions.add("n.namespace_name = :namespace_name");
            bindings.put("namespace_name", namespaceName.get());
        }
        if (objectType.isPresent()) {
            conditions.add("t.table_type = :table_type");
            switch (objectType.get()) {
                case "table": {
                    bindings.put("table_type", IcebergTableType.TABLE.getIdentifier());
                    conditions.add("t.mv = :mv");
                    bindings.put("mv", 0);
                    break;
                }
                case "view": {
                    bindings.put("table_type", IcebergTableType.VIEW.getIdentifier());
                    break;
                }
                case "cedrusdata-materialized-view": {
                    bindings.put("table_type", IcebergTableType.TABLE.getIdentifier());
                    conditions.add("t.mv = :mv");
                    bindings.put("mv", 1);
                    break;
                }
                default: {
                    throw new CatalogBadRequestException("Unsupported object type: " + objectType.get());
                }
            }
        }
        PageProcessor<IcebergTableInfoWithId> pageProcessor = this.icebergTableListForApiPageProcessorFactory.create(page);
        List items = this.accessor.execute(handle -> pageProcessor.createQuery((Handle)handle, (List<String>)conditions, (Map<String, Object>)bindings).map((rs, ctx) -> new IcebergTableInfoWithId(this.getUuid(rs, "table_id"), AbstractJdbcCatalogStore.toIcebergTableInfoInternal(rs))).list());
        return new IcebergObjectListResponse(items.stream().map(item -> AbstractJdbcCatalogStore.toIcebergObjectInfo(item.info())).toList(), pageProcessor.nextPageToken(items));
    }

    @Override
    public Optional<IcebergObjectInfo> getIcebergObjectForApi(String catalogName, String namespaceName, String objectName) {
        return this.getIcebergObjectForApiInternal(catalogName, namespaceName, objectName).map(AbstractJdbcCatalogStore::toIcebergObjectInfo);
    }

    private Optional<IcebergTableInfo> getIcebergObjectForApiInternal(String catalogName, String namespaceName, String objectName) {
        return this.accessor.execute(handle -> ((Query)((Query)((Query)handle.createQuery(SQL_ICEBERG_TABLE_INFO).bind("catalog_name", catalogName)).bind("namespace_name", namespaceName)).bind("table_name", objectName)).map((rs, ctx) -> AbstractJdbcCatalogStore.toIcebergTableInfoInternal(rs)).findOne());
    }

    private static IcebergObjectInfo toIcebergObjectInfo(IcebergTableInfo info) {
        Verify.verify((info.tableType() == IcebergTableType.TABLE || info.tableType() == IcebergTableType.VIEW ? 1 : 0) != 0);
        String type = info.tableType() == IcebergTableType.TABLE ? (info.mv() ? "cedrusdata-materialized-view" : "table") : "view";
        return new IcebergObjectInfo(info.catalogName(), info.namespaceName(), info.tableName(), type, info.metadataLocation(), info.previousMetadataLocation());
    }

    private static IcebergTableInfo toIcebergTableInfoInternal(ResultSet rs) throws SQLException {
        return new IcebergTableInfo(rs.getString("catalog_name"), rs.getString("namespace_name"), rs.getString("table_name"), IcebergTableType.resolve(rs.getInt("table_type")), rs.getString("metadata_location"), rs.getString("previous_metadata_location"), rs.getShort("mv") != 0);
    }

    @Override
    public IcebergMaterializedViewForRewriteListResponse listIcebergMaterializedViewsForRewriteForApi(String catalogName, Set<String> tableNames) {
        if (tableNames.isEmpty()) {
            return new IcebergMaterializedViewForRewriteListResponse(List.of());
        }
        StringJoiner referencedTablesCondition = new StringJoiner(", ");
        for (int i = 0; i < tableNames.size(); ++i) {
            referencedTablesCondition.add(":table_" + i);
        }
        String sql = SQL_ICEBERG_MATERIALIZED_VIEWS_FOR_REWRITE.replace("{referenced_table_names}", referencedTablesCondition.toString());
        List items = this.accessor.execute(handle -> {
            Query query = (Query)handle.createQuery(sql).bind("catalog_name", catalogName);
            int i = 0;
            for (String tableName : tableNames) {
                query.bind("table_" + i++, tableName);
            }
            return query.map((rs, ctx) -> new IcebergMaterializedViewForRewriteInfo(rs.getString("namespace_name"), rs.getString("table_name"), rs.getString("plan"), Long.valueOf(rs.getLong("snapshot_id")))).list();
        });
        return new IcebergMaterializedViewForRewriteListResponse(items);
    }

    private static String propertiesToString(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        return PROPERTIES_CODEC.toJson(properties);
    }

    private static Map<String, String> stringToProperties(String value) {
        if (value == null) {
            return Map.of();
        }
        return (Map)PROPERTIES_CODEC.fromJson(value);
    }

    protected boolean isConstraintViolationException(Throwable throwable) {
        while (!this.isConstraintViolationExceptionInternal(throwable)) {
            Throwable cause = throwable.getCause();
            if (cause == null || cause == throwable) {
                return false;
            }
            throwable = cause;
        }
        return true;
    }

    protected abstract boolean isConstraintViolationExceptionInternal(Throwable var1);

    protected abstract UUID getUuid(ResultSet var1, String var2) throws SQLException;

    protected abstract String forUpdate(String var1);

    @VisibleForTesting
    public List<Map<String, Object>> dumpTable(String tableName) {
        return this.accessor.execute(handle -> this.dumpTable((Handle)handle, tableName));
    }

    private List<Map<String, Object>> dumpTable(Handle handle, String tableName) {
        return handle.createQuery("SELECT * FROM " + tableName).mapToMap().stream().toList();
    }

    private record RoleLink(UUID fromId, UUID toId) {
    }

    private record FileSystemInfoWithId(UUID id, FileSystemInfo info) {
    }

    private record IcebergTableInfo(String catalogName, String namespaceName, String tableName, IcebergTableType tableType, String metadataLocation, String previousMetadataLocation, boolean mv) {
    }

    private record IcebergTableInfoWithId(UUID id, IcebergTableInfo info) {
    }

    private record IcebergTableNameWithId(UUID id, String name) {
    }

    private record IcebergNamespaceNameWithId(UUID id, String name) {
    }

    private record IcebergNamespaceInfoWithId(UUID id, IcebergNamespaceInfo info) {
    }

    private record IcebergCatalogInfoWithId(UUID id, IcebergCatalogInfo info) {
    }

    private record PrincipalInfoWithId(UUID id, PrincipalInfo info) {
    }
}

