/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.filesystem.FileSystemDetails;
import ru.cedrusdata.catalog.core.principal.PrincipalDetails;
import ru.cedrusdata.catalog.core.principal.PrincipalIdAndType;
import ru.cedrusdata.catalog.core.principal.PrincipalType;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;

public interface CatalogStore {
    public void initialize();

    public Optional<UUID> createPrincipalIfNotExists(String var1, PrincipalType var2, String var3, Map<UUID, String> var4, boolean var5, Map<String, String> var6);

    public boolean updatePrincipalIfExists(UUID var1, String var2, boolean var3, Map<String, String> var4, Optional<String> var5);

    public boolean deletePrincipalIfExists(UUID var1, String var2);

    public Optional<UUID> getPrincipalIdByName(String var1);

    public Optional<PrincipalDetails> getPrincipalDetailsByName(String var1, boolean var2);

    public Optional<PrincipalDetails> getPrincipalDetailsByAccessTokenId(String var1);

    public Optional<PrincipalInfo> getPrincipal(String var1);

    public Map<String, PrincipalIdAndType> getPrincipalIdAndType(Collection<String> var1);

    public PrincipalListResponse listPrincipals(Optional<String> var1, ResultPage var2);

    public long countUserPrincipals();

    public void createAccessToken(UUID var1, String var2, String var3, String var4, String var5);

    public boolean deleteAccessTokenIfExists(String var1);

    public AccessTokenListResponse listAccessTokens(ResultPage var1);

    public AccessTokenListResponse listPrincipalAccessTokens(UUID var1, ResultPage var2);

    public List<String> listPrincipalAccessTokenIds(UUID var1);

    public Map<String, UUID> listRoles();

    public boolean grantRoleIfNotGranted(UUID var1, String var2, UUID var3, String var4);

    public boolean revokeRoleIfGranted(UUID var1, UUID var2);

    public boolean createFileSystemIfNotExists(UUID var1, String var2, String var3, CatalogFileSystemType var4, Map<String, String> var5);

    public boolean updateFileSystemIfExists(UUID var1, String var2, String var3, Map<String, String> var4);

    public boolean deleteFileSystemIfExists(UUID var1, String var2);

    public Optional<FileSystemDetails> fileSystemDetails(String var1);

    public List<FileSystemDetails> fileSystemAllDetails();

    public Optional<FileSystemInfo> getFileSystem(String var1);

    public FileSystemListResponse listFileSystems(ResultPage var1);

    public Optional<UUID> createIcebergCatalogIfNotExists(String var1, String var2, UUID var3, String var4, String var5, Map<String, String> var6);

    public boolean updateIcebergCatalogIfExists(UUID var1, String var2, String var3, String var4, Map<String, String> var5);

    public boolean deleteIcebergCatalogIfExists(UUID var1, String var2);

    public List<IcebergCatalogDetails> listIcebergCatalogDetails();

    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage var1);

    public Optional<UUID> createIcebergNamespaceIfNotExists(String var1, UUID var2, String var3, Map<String, String> var4);

    public boolean updateIcebergNamespaceIfExists(UUID var1, Map<String, String> var2);

    public boolean deleteIcebergNamespaceIfExists(UUID var1, String var2, String var3);

    public List<IcebergNamespaceDetails> listIcebergNamespaceDetails();

    public IcebergNamespaceListResponse listIcebergNamespacesForApi(Optional<String> var1, ResultPage var2);

    public IcebergNamespaceListResult listIcebergNamespaces(UUID var1, ResultPage var2);

    public boolean createIcebergTableIfNotExist(UUID var1, String var2, IcebergTableType var3, String var4, Optional<IcebergMaterializedViewDetails> var5);

    public boolean updateIcebergTableIfExists(UUID var1, String var2, IcebergTableType var3, String var4, String var5, Optional<IcebergMaterializedViewDetails> var6);

    public boolean renameIcebergTableIfExists(String var1, UUID var2, String var3, String var4, UUID var5, String var6, IcebergTableType var7);

    public boolean deleteIcebergTableIfExists(UUID var1, String var2, IcebergTableType var3);

    public Optional<String> getIcebergTableMetadataLocation(String var1, String var2, UUID var3, String var4, IcebergTableType var5);

    public IcebergTableListResult listIcebergTables(UUID var1, IcebergTableType var2, ResultPage var3);

    public IcebergObjectListResponse listIcebergObjectsForApi(Optional<String> var1, Optional<String> var2, Optional<String> var3, ResultPage var4);

    public Optional<IcebergObjectInfo> getIcebergObjectForApi(String var1, String var2, String var3);

    public IcebergMaterializedViewForRewriteListResponse listIcebergMaterializedViewsForRewriteForApi(String var1, Set<String> var2);
}

