/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.spi.CatalogObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.RoleGrantRequest;
import ru.cedrusdata.catalog.spi.model.RoleRevokeRequest;

public class V1ApiImpl {
    private final EmbeddedInternalCatalogClientFactory clientFactory;

    @Inject
    public V1ApiImpl(EmbeddedInternalCatalogClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public Response createPrincipal(AuthenticationContext principal, PrincipalCreateRequest request) {
        this.clientFactory.createClient(principal).createPrincipal(request);
        return Response.noContent().build();
    }

    public Response updatePrincipal(AuthenticationContext context, String principalName, PrincipalUpdateRequest request) {
        principalName = CatalogUtils.decodeString(CatalogObjectType.PRINCIPAL, principalName);
        this.clientFactory.createClient(context).updatePrincipal(principalName, request);
        return Response.noContent().build();
    }

    public Response deletePrincipal(AuthenticationContext context, String principalName) {
        principalName = CatalogUtils.decodeString(CatalogObjectType.PRINCIPAL, principalName);
        this.clientFactory.createClient(context).deletePrincipal(principalName);
        return Response.noContent().build();
    }

    public Response getPrincipal(AuthenticationContext context, String principalName) {
        principalName = CatalogUtils.decodeString(CatalogObjectType.PRINCIPAL, principalName);
        PrincipalInfo result = this.clientFactory.createClient(context).getPrincipal(principalName);
        return Response.ok((Object)result).build();
    }

    public Response listPrincipals(AuthenticationContext context, String principalType, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        PrincipalListResponse result = this.clientFactory.createClient(context).listPrincipals(Optional.ofNullable(principalType), page);
        return Response.ok((Object)result).build();
    }

    public Response createTemporaryAccessToken(AuthenticationContext context, String subject) {
        subject = CatalogUtils.decodeString(CatalogObjectType.PRINCIPAL, subject);
        AccessTokenCreateTemporaryResponse result = this.clientFactory.createClient(context).createTemporaryAccessToken(subject);
        return Response.ok((Object)result).build();
    }

    public Response createAccessToken(AuthenticationContext context, AccessTokenCreateRequest request) {
        AccessTokenCreateResponse response = this.clientFactory.createClient(context).createAccessToken(request);
        return Response.ok((Object)response).build();
    }

    public Response deleteAccessToken(AuthenticationContext context, String accessTokenId) {
        this.clientFactory.createClient(context).deleteAccessToken(accessTokenId);
        return Response.noContent().build();
    }

    public Response listAccessTokens(AuthenticationContext context, String principalName, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        AccessTokenListResponse response = this.clientFactory.createClient(context).listAccessTokens(CatalogUtils.decodeOptionalString(CatalogObjectType.PRINCIPAL, principalName), page);
        return Response.ok((Object)response).build();
    }

    public Response grantRole(AuthenticationContext context, String roleName, RoleGrantRequest request) {
        roleName = CatalogUtils.decodeString(CatalogObjectType.ROLE, roleName);
        this.clientFactory.createClient(context).grantRole(roleName, request);
        return Response.noContent().build();
    }

    public Response revokeRole(AuthenticationContext context, String roleName, RoleRevokeRequest request) {
        roleName = CatalogUtils.decodeString(CatalogObjectType.ROLE, roleName);
        this.clientFactory.createClient(context).revokeRole(roleName, request);
        return Response.noContent().build();
    }

    public Response createFileSystem(AuthenticationContext context, FileSystemCreateRequest request) {
        this.clientFactory.createClient(context).createFileSystem(request);
        return Response.noContent().build();
    }

    public Response updateFileSystem(AuthenticationContext context, String fileSystem, FileSystemUpdateRequest request) {
        fileSystem = CatalogUtils.decodeString(CatalogObjectType.FILE_SYSTEM, fileSystem);
        this.clientFactory.createClient(context).updateFileSystem(fileSystem, request);
        return Response.noContent().build();
    }

    public Response deleteFileSystem(AuthenticationContext context, String fileSystem) {
        fileSystem = CatalogUtils.decodeString(CatalogObjectType.FILE_SYSTEM, fileSystem);
        this.clientFactory.createClient(context).deleteFileSystem(fileSystem);
        return Response.noContent().build();
    }

    public Response getFileSystem(AuthenticationContext context, String fileSystem) {
        fileSystem = CatalogUtils.decodeString(CatalogObjectType.FILE_SYSTEM, fileSystem);
        FileSystemInfo response = this.clientFactory.createClient(context).getFileSystem(fileSystem);
        return Response.ok((Object)response).build();
    }

    public Response listFileSystems(AuthenticationContext context, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        FileSystemListResponse result = this.clientFactory.createClient(context).listFileSystems(page);
        return Response.ok((Object)result).build();
    }

    public Response checkFileSystem(AuthenticationContext principal, FileSystemCheckRequest request) {
        FileSystemCheckResponse result = this.clientFactory.createClient(principal).checkFileSystem(request);
        return Response.ok((Object)result).build();
    }

    public Response createIcebergCatalog(AuthenticationContext principal, IcebergCatalogCreateRequest request) {
        this.clientFactory.createClient(principal).createIcebergCatalog(request);
        return Response.noContent().build();
    }

    public Response updateIcebergCatalog(AuthenticationContext principal, String catalog, IcebergCatalogUpdateRequest request) {
        catalog = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        this.clientFactory.createClient(principal).updateIcebergCatalog(catalog, request);
        return Response.noContent().build();
    }

    public Response deleteIcebergCatalog(AuthenticationContext principal, String catalog) {
        catalog = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        this.clientFactory.createClient(principal).deleteIcebergCatalog(catalog);
        return Response.noContent().build();
    }

    public Response getIcebergCatalog(AuthenticationContext principal, String catalog) {
        catalog = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        IcebergCatalogInfo response = this.clientFactory.createClient(principal).getIcebergCatalog(catalog);
        return Response.ok((Object)response).build();
    }

    public Response listIcebergCatalogs(AuthenticationContext context, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        IcebergCatalogListResponse result = this.clientFactory.createClient(context).listIcebergCatalogs(page);
        return Response.ok((Object)result).build();
    }

    public Response getIcebergNamespace(AuthenticationContext context, String catalog, String namespace) {
        catalog = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        namespace = CatalogUtils.flattenIcebergNamespace(CatalogUtils.decodeIcebergNamespace(namespace));
        IcebergNamespaceInfo response = this.clientFactory.createClient(context).getIcebergNamespace(catalog, namespace);
        return Response.ok((Object)response).build();
    }

    public Response listIcebergNamespaces(AuthenticationContext context, String catalog, String pageToken, Integer pageSize) {
        Optional<String> optionalCatalog = CatalogUtils.decodeOptionalString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        IcebergNamespaceListResponse result = this.clientFactory.createClient(context).listIcebergNamespaces(optionalCatalog, page);
        return Response.ok((Object)result).build();
    }

    public Response getIcebergObject(AuthenticationContext context, String catalog, String namespace, String object) {
        catalog = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        namespace = CatalogUtils.flattenIcebergNamespace(CatalogUtils.decodeIcebergNamespace(namespace));
        object = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, object);
        IcebergObjectInfo response = this.clientFactory.createClient(context).getIcebergObject(catalog, namespace, object);
        return Response.ok((Object)response).build();
    }

    public Response listIcebergObjects(AuthenticationContext context, String catalog, String namespaceName, String objectType, String pageToken, Integer pageSize) {
        Optional<String> optionalCatalog = CatalogUtils.decodeOptionalString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        Optional<String> optionalNamespace = CatalogUtils.decodeOptionalIcebergNamespace(namespaceName).map(CatalogUtils::flattenIcebergNamespace);
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        IcebergObjectListResponse result = this.clientFactory.createClient(context).listIcebergObjects(optionalCatalog, optionalNamespace, Optional.ofNullable(objectType), page);
        return Response.ok((Object)result).build();
    }

    public Response listMaterializedViewsForRewrite(AuthenticationContext context, String catalog, IcebergMaterializedViewForRewriteListRequest request) {
        catalog = CatalogUtils.decodeString(CatalogObjectType.ICEBERG_CATALOG, catalog);
        IcebergMaterializedViewForRewriteListResponse result = this.clientFactory.createClient(context).listMaterializedViewsForRewrite(catalog, request);
        return Response.ok((Object)result).build();
    }
}

