/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.server.rest.V1ApiImpl;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.RoleGrantRequest;
import ru.cedrusdata.catalog.spi.model.RoleRevokeRequest;

@ResourceType(value=ResourceType.Type.CATALOG)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
@Path(value="/v1")
public class V1Api {
    private final V1ApiImpl apiImpl;

    @Inject
    public V1Api(V1ApiImpl apiImpl) {
        this.apiImpl = apiImpl;
    }

    @POST
    @Path(value="/file-system-check")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkFileSystem(FileSystemCheckRequest fileSystemCheckRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.checkFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystemCheckRequest);
    }

    @POST
    @Path(value="/access-tokens")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAccessToken(AccessTokenCreateRequest accessTokenCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createAccessToken(CatalogUtils.getAuthenticationContext(securityContext), accessTokenCreateRequest);
    }

    @POST
    @Path(value="/file-systems")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFileSystem(FileSystemCreateRequest fileSystemCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystemCreateRequest);
    }

    @POST
    @Path(value="/iceberg-catalogs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createIcebergCatalog(IcebergCatalogCreateRequest icebergCatalogCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalogCreateRequest);
    }

    @POST
    @Path(value="/principals")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPrincipal(PrincipalCreateRequest principalCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createPrincipal(CatalogUtils.getAuthenticationContext(securityContext), principalCreateRequest);
    }

    @POST
    @Path(value="/access-tokens-temporary/{principal}")
    @Produces(value={"application/json"})
    public Response createTemporaryAccessToken(@PathParam(value="principal") String principal, @Context SecurityContext securityContext) {
        return this.apiImpl.createTemporaryAccessToken(CatalogUtils.getAuthenticationContext(securityContext), principal);
    }

    @DELETE
    @Path(value="/access-tokens/{access-token-id}")
    @Produces(value={"application/json"})
    public Response deleteAccessToken(@PathParam(value="access-token-id") String accessTokenId, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteAccessToken(CatalogUtils.getAuthenticationContext(securityContext), accessTokenId);
    }

    @DELETE
    @Path(value="/file-systems/{file-system}")
    @Produces(value={"application/json"})
    public Response deleteFileSystem(@PathParam(value="file-system") String fileSystem, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystem);
    }

    @DELETE
    @Path(value="/iceberg-catalogs/{iceberg-catalog}")
    @Produces(value={"application/json"})
    public Response deleteIcebergCatalog(@PathParam(value="iceberg-catalog") String icebergCatalog, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog);
    }

    @DELETE
    @Path(value="/principals/{principal}")
    @Produces(value={"application/json"})
    public Response deletePrincipal(@PathParam(value="principal") String principal, @Context SecurityContext securityContext) {
        return this.apiImpl.deletePrincipal(CatalogUtils.getAuthenticationContext(securityContext), principal);
    }

    @GET
    @Path(value="/file-systems/{file-system}")
    @Produces(value={"application/json"})
    public Response getFileSystem(@PathParam(value="file-system") String fileSystem, @Context SecurityContext securityContext) {
        return this.apiImpl.getFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystem);
    }

    @GET
    @Path(value="/iceberg-catalogs/{iceberg-catalog}")
    @Produces(value={"application/json"})
    public Response getIcebergCatalog(@PathParam(value="iceberg-catalog") String icebergCatalog, @Context SecurityContext securityContext) {
        return this.apiImpl.getIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog);
    }

    @GET
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/namespaces/{iceberg-namespace}")
    @Produces(value={"application/json"})
    public Response getIcebergNamespace(@PathParam(value="iceberg-catalog") String icebergCatalog, @PathParam(value="iceberg-namespace") String icebergNamespace, @Context SecurityContext securityContext) {
        return this.apiImpl.getIcebergNamespace(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergNamespace);
    }

    @GET
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/namespaces/{iceberg-namespace}/objects/{iceberg-object}")
    @Produces(value={"application/json"})
    public Response getIcebergObject(@PathParam(value="iceberg-catalog") String icebergCatalog, @PathParam(value="iceberg-namespace") String icebergNamespace, @PathParam(value="iceberg-object") String icebergObject, @Context SecurityContext securityContext) {
        return this.apiImpl.getIcebergObject(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergNamespace, icebergObject);
    }

    @GET
    @Path(value="/principals/{principal}")
    @Produces(value={"application/json"})
    public Response getPrincipal(@PathParam(value="principal") String principal, @Context SecurityContext securityContext) {
        return this.apiImpl.getPrincipal(CatalogUtils.getAuthenticationContext(securityContext), principal);
    }

    @POST
    @Path(value="/roles/{role}/grant")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response grantRole(@PathParam(value="role") String role, RoleGrantRequest roleGrantRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.grantRole(CatalogUtils.getAuthenticationContext(securityContext), role, roleGrantRequest);
    }

    @GET
    @Path(value="/access-tokens")
    @Produces(value={"application/json"})
    public Response listAccessTokens(@QueryParam(value="principalName") String principalName, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listAccessTokens(CatalogUtils.getAuthenticationContext(securityContext), principalName, pageToken, pageSize);
    }

    @GET
    @Path(value="/file-systems")
    @Produces(value={"application/json"})
    public Response listFileSystems(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listFileSystems(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize);
    }

    @GET
    @Path(value="/iceberg-catalogs")
    @Produces(value={"application/json"})
    public Response listIcebergCatalogs(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listIcebergCatalogs(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize);
    }

    @GET
    @Path(value="/iceberg-namespaces")
    @Produces(value={"application/json"})
    public Response listIcebergNamespaces(@QueryParam(value="catalog") String catalog, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listIcebergNamespaces(CatalogUtils.getAuthenticationContext(securityContext), catalog, pageToken, pageSize);
    }

    @GET
    @Path(value="/iceberg-objects")
    @Produces(value={"application/json"})
    public Response listIcebergObjects(@QueryParam(value="catalog") String catalog, @QueryParam(value="namespace") String namespace, @QueryParam(value="objectType") String objectType, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listIcebergObjects(CatalogUtils.getAuthenticationContext(securityContext), catalog, namespace, objectType, pageToken, pageSize);
    }

    @POST
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/materialized-views-for-rewrite")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listMaterializedViewsForRewrite(@PathParam(value="iceberg-catalog") String icebergCatalog, IcebergMaterializedViewForRewriteListRequest icebergMaterializedViewForRewriteListRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.listMaterializedViewsForRewrite(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergMaterializedViewForRewriteListRequest);
    }

    @GET
    @Path(value="/principals")
    @Produces(value={"application/json"})
    public Response listPrincipals(@QueryParam(value="principalType") String principalType, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listPrincipals(CatalogUtils.getAuthenticationContext(securityContext), principalType, pageToken, pageSize);
    }

    @POST
    @Path(value="/roles/{role}/revoke")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revokeRole(@PathParam(value="role") String role, RoleRevokeRequest roleRevokeRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.revokeRole(CatalogUtils.getAuthenticationContext(securityContext), role, roleRevokeRequest);
    }

    @POST
    @Path(value="/file-systems/{file-system}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateFileSystem(@PathParam(value="file-system") String fileSystem, FileSystemUpdateRequest fileSystemUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystem, fileSystemUpdateRequest);
    }

    @POST
    @Path(value="/iceberg-catalogs/{iceberg-catalog}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateIcebergCatalog(@PathParam(value="iceberg-catalog") String icebergCatalog, IcebergCatalogUpdateRequest icebergCatalogUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergCatalogUpdateRequest);
    }

    @POST
    @Path(value="/principals/{principal}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePrincipal(@PathParam(value="principal") String principal, PrincipalUpdateRequest principalUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updatePrincipal(CatalogUtils.getAuthenticationContext(securityContext), principal, principalUpdateRequest);
    }
}

