/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.filters.RequestClassifierFilter;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.exception.CatalogServiceUnavailableException;

@Priority(value=3)
public class ServerInitializedFilter
implements ContainerRequestFilter {
    private static final String INFO_PATH = "/v1/info";
    private static final String ERROR_MESSAGE = "CedrusData Catalog server is still initializing";
    private final ServerInitializationInfo serverInitializationInfo;

    public ServerInitializedFilter(ServerInitializationInfo serverInitializationInfo) {
        this.serverInitializationInfo = serverInitializationInfo;
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.serverInitializationInfo.isInitialized()) {
            return;
        }
        if (ServerInitializedFilter.bypassInitializationCheck(requestContext)) {
            return;
        }
        ResourceType.Type resourceType = RequestClassifierFilter.getRequestType(requestContext);
        switch (resourceType) {
            case CATALOG: 
            case CATALOG_ADMIN: 
            case OTHER: {
                throw new CatalogServiceUnavailableException(ERROR_MESSAGE);
            }
            case ICEBERG: {
                throw new ServiceUnavailableException(ERROR_MESSAGE, new Object[0]);
            }
        }
    }

    private static boolean bypassInitializationCheck(ContainerRequestContext requestContext) {
        String path = requestContext.getUriInfo().getRequestUri().getPath();
        return INFO_PATH.equals(path);
    }
}

