/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.filters;

import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import ru.cedrusdata.catalog.server.security.ResourceType;

@Priority(value=2)
public class RequestClassifierFilter
implements ContainerRequestFilter {
    private static final String PROPERTY_REQUEST_TYPE = "cedrusdata.catalog.$internal.request-type";
    private final ResourceType.Type type;

    public RequestClassifierFilter(ResourceType.Type type) {
        this.type = type;
    }

    public static ResourceType.Type getRequestType(HttpServletRequest request) {
        ResourceType.Type res = (ResourceType.Type)((Object)request.getAttribute(PROPERTY_REQUEST_TYPE));
        if (res == null) {
            return ResourceType.Type.OTHER;
        }
        return res;
    }

    public static ResourceType.Type getRequestType(ContainerRequestContext requestContext) {
        ResourceType.Type res = (ResourceType.Type)((Object)requestContext.getProperty(PROPERTY_REQUEST_TYPE));
        if (res == null) {
            return ResourceType.Type.OTHER;
        }
        return res;
    }

    public void filter(ContainerRequestContext requestContext) {
        requestContext.setProperty(PROPERTY_REQUEST_TYPE, (Object)this.type);
    }
}

