/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.filters;

import com.google.inject.Inject;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.core.principal.JwtCredentials;
import ru.cedrusdata.catalog.core.principal.JwtTokenManager;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.server.filters.RequestClassifierFilter;
import ru.cedrusdata.catalog.server.security.BasicAuthentication;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.exception.CatalogAuthenticationException;
import ru.cedrusdata.catalog.spi.exception.CatalogAuthorizationException;
import ru.cedrusdata.catalog.spi.security.CatalogPrivilege;

@Priority(value=4)
public class AuthenticationFilter
implements ContainerRequestFilter {
    private static final String HEADER_SUBJECT = "X-Catalog-Subject";
    private final PrincipalService principalService;
    private final JwtTokenManager tokenManager;

    @Inject
    public AuthenticationFilter(PrincipalService principalService, JwtTokenManager tokenManager) {
        this.principalService = Objects.requireNonNull(principalService, "userService");
        this.tokenManager = Objects.requireNonNull(tokenManager, "tokenManager");
    }

    public void filter(ContainerRequestContext requestContext) {
        ResourceType.Type resourceType = RequestClassifierFilter.getRequestType(requestContext);
        Optional<AuthenticationContext> context = this.authenticateBearer(requestContext);
        if (context.isEmpty()) {
            context = this.authenticateBasic(requestContext);
        }
        if (context.isPresent()) {
            context = this.impersonate(context.get(), requestContext);
        }
        if (context.isEmpty()) {
            if (resourceType == ResourceType.Type.ICEBERG) {
                throw new NotAuthorizedException("Unauthorized", new Object[0]);
            }
            throw new CatalogAuthenticationException();
        }
        if (resourceType == ResourceType.Type.CATALOG_ADMIN && !context.get().subject().admin()) {
            throw new CatalogAuthorizationException(CatalogPrivilege.MANAGEMENT_READ);
        }
        CatalogUtils.setAuthenticationContext(requestContext, context.get());
    }

    private Optional<AuthenticationContext> authenticateBearer(ContainerRequestContext requestContext) {
        Optional<AuthenticatedPrincipal> user;
        Optional<String> token = CatalogUtils.extractBearer(requestContext.getHeaderString("Authorization"));
        if (token.isEmpty()) {
            return Optional.empty();
        }
        if (token.get().startsWith("U-") && (user = this.principalService.authenticateAccessToken(token.get())).isPresent()) {
            return user.map(AuthenticatedPrincipal::toContext);
        }
        Optional<JwtCredentials> subjectCredentials = this.tokenManager.unwrapCredentials(token.get());
        if (subjectCredentials.isPresent()) {
            Optional<AuthenticatedPrincipal> subjectPrincipal = this.principalService.authenticate(subjectCredentials.get().subject());
            if (subjectPrincipal.isEmpty()) {
                return Optional.empty();
            }
            if (subjectCredentials.get().subject().equals(subjectCredentials.get().actor())) {
                return subjectPrincipal.map(AuthenticatedPrincipal::toContext);
            }
            Optional<AuthenticatedPrincipal> actorPrincipal = this.principalService.authenticate(subjectCredentials.get().actor());
            return actorPrincipal.map(actor -> new AuthenticationContext((AuthenticatedPrincipal)actor, (AuthenticatedPrincipal)subjectPrincipal.get()));
        }
        return Optional.empty();
    }

    private Optional<AuthenticationContext> authenticateBasic(ContainerRequestContext requestContext) {
        Optional<BasicAuthentication> auth = CatalogUtils.extractBasic(requestContext.getHeaderString("Authorization"));
        if (auth.isEmpty()) {
            return Optional.empty();
        }
        return this.principalService.authenticate(auth.get().principal(), auth.get().password()).map(AuthenticatedPrincipal::toContext);
    }

    private Optional<AuthenticationContext> impersonate(AuthenticationContext context, ContainerRequestContext requestContext) {
        String subject = requestContext.getHeaderString(HEADER_SUBJECT);
        if (subject == null) {
            return Optional.of(context);
        }
        return Optional.of(this.principalService.impersonate(context, subject));
    }
}

