/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.jaxrs.JaxrsBinder;
import java.util.Objects;
import ru.cedrusdata.catalog.server.FaviconResource;
import ru.cedrusdata.catalog.server.ResourceDynamicFeature;
import ru.cedrusdata.catalog.server.ServerExceptionMapper;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.ServerVersion;
import ru.cedrusdata.catalog.server.filters.AuthenticationFilter;
import ru.cedrusdata.catalog.server.rest.V1Api;
import ru.cedrusdata.catalog.server.rest.V1ApiImpl;
import ru.cedrusdata.catalog.server.rest.V1InfoApi;

public class ServerModule
extends AbstractConfigurationAwareModule {
    private final String version;

    public ServerModule(String version) {
        this.version = Objects.requireNonNull(version, "version is null");
    }

    protected void setup(Binder binder) {
        binder.bind(ServerInitializationInfo.class).in(Scopes.SINGLETON);
        binder.bind(ServerVersion.class).toInstance((Object)new ServerVersion(this.version));
        binder.bind(AuthenticationFilter.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ResourceDynamicFeature.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(V1InfoApi.class);
        binder.bind(V1ApiImpl.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(V1Api.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(FaviconResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServerExceptionMapper.class);
    }
}

