/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.CedrusDataBootstrap;
import io.airlift.event.client.EventModule;
import io.airlift.event.client.JsonEventModule;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientModule;
import ru.cedrusdata.catalog.core.CoreModule;
import ru.cedrusdata.catalog.iceberg.IcebergModule;
import ru.cedrusdata.catalog.jmx.CatalogJmxModule;
import ru.cedrusdata.catalog.plugin.CatalogPluginModule;
import ru.cedrusdata.catalog.server.CatalogHttpServerModule;
import ru.cedrusdata.catalog.server.JsonModule;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.ServerModule;
import ru.cedrusdata.catalog.server.ServerVersion;
import ru.cedrusdata.catalog.server.jaxrs.CatalogJaxrsModule;
import ru.cedrusdata.catalog.store.CatalogStoreModule;
import ru.cedrusdata.catalog.tracing.CatalogTracingModule;

public class CatalogServer {
    private static void addMessages(StringBuilder output, String type, List<Object> messages) {
        if (messages.isEmpty()) {
            return;
        }
        output.append("\n").append(type).append(":\n\n");
        for (int index = 0; index < messages.size(); ++index) {
            output.append(String.format("%s) %s\n", index + 1, messages.get(index)));
        }
    }

    private static void logLocation(Logger log, String name, Path path) {
        if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            log.info("%s: [does not exist]", new Object[]{name});
            return;
        }
        try {
            path = path.toAbsolutePath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            log.info("%s: [not accessible]", new Object[]{name});
            return;
        }
        log.info("%s: %s", new Object[]{name, path});
    }

    public void start(String catalogVersion) {
        this.start(catalogVersion, true);
    }

    public void start(String catalogVersion, boolean shutdownOnError) {
        this.start(catalogVersion, shutdownOnError, true);
    }

    public void start(String catalogVersion, boolean shutdownOnError, boolean logInfoMessages) {
        long startTime = System.nanoTime();
        Logger log = Logger.get(CatalogServer.class);
        if (logInfoMessages) {
            log.info("Java version: %s", new Object[]{StandardSystemProperty.JAVA_VERSION.value()});
        }
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{this.getHttpServerModule(), new JsonModule(), new CatalogJaxrsModule(), new EventModule(), new JsonEventModule(), this.getJmxModule(), new CatalogTracingModule(catalogVersion), new CatalogStoreModule(), new CoreModule(), new EmbeddedInternalCatalogClientModule(), new IcebergModule(), new CatalogPluginModule(), new ServerModule(catalogVersion)});
        Optional<Module> additionalModule = this.getAdditionalModule();
        if (additionalModule.isPresent()) {
            modules.add((Object)additionalModule.get());
        }
        CedrusDataBootstrap app = new CedrusDataBootstrap((Iterable)modules.build());
        try {
            Injector injector = this.createInjector(app);
            if (logInfoMessages) {
                log.info("CedrusData Catalog version: %s", new Object[]{((ServerVersion)injector.getInstance(ServerVersion.class)).getVersion()});
                CatalogServer.logLocation(log, "Working directory", Paths.get(".", new String[0]));
                CatalogServer.logLocation(log, "Etc directory", Paths.get("etc", new String[0]));
                log.info("Server startup completed in %s", new Object[]{Duration.nanosSince((long)startTime).convertToMostSuccinctTimeUnit()});
                log.info("======== SERVER STARTED ========");
            }
            ((ServerInitializationInfo)injector.getInstance(ServerInitializationInfo.class)).onInitialized();
        }
        catch (ApplicationConfigurationException e) {
            StringBuilder message = new StringBuilder();
            message.append("CedrusData Catalog Configuration is invalid\n");
            message.append("==========\n");
            CatalogServer.addMessages(message, "Errors", (List<Object>)ImmutableList.copyOf((Collection)e.getErrors()));
            CatalogServer.addMessages(message, "Warnings", (List<Object>)ImmutableList.copyOf((Collection)e.getWarnings()));
            message.append("\n");
            message.append("==========");
            log.error("%s", new Object[]{message});
            if (shutdownOnError) {
                System.exit(100);
            }
            throw e;
        }
        catch (Throwable e) {
            log.error(e);
            if (shutdownOnError) {
                System.exit(100);
            }
            throw e;
        }
    }

    protected Module getHttpServerModule() {
        return new CatalogHttpServerModule();
    }

    protected Module getJmxModule() {
        return new CatalogJmxModule();
    }

    protected Optional<Module> getAdditionalModule() {
        return Optional.empty();
    }

    protected Injector createInjector(CedrusDataBootstrap app) {
        return app.initialize();
    }
}

