/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.plugin.CatalogPluginClassLoaderFactory;
import ru.cedrusdata.catalog.plugin.CatalogPluginLoader;
import ru.cedrusdata.catalog.plugin.CatalogPluginManager;
import ru.cedrusdata.catalog.plugin.CatalogPluginProvider;

public class DefaultCatalogPluginProvider
implements CatalogPluginProvider {
    private final File installedPluginsDir;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"startup-%s"));

    @Inject
    private DefaultCatalogPluginProvider(CatalogConfig config) {
        this.installedPluginsDir = config.getPluginDir();
    }

    @Override
    public void loadPlugins(CatalogPluginManager manager, CatalogPluginLoader loader, CatalogPluginClassLoaderFactory classLoaderFactory) {
        List<File> pluginDirs = DefaultCatalogPluginProvider.listFiles(this.installedPluginsDir).stream().filter(File::isDirectory).toList();
        ArrayList tasks = new ArrayList(pluginDirs.size());
        for (File pluginDir : pluginDirs) {
            tasks.add(() -> {
                loader.load(pluginDir.getAbsolutePath(), () -> classLoaderFactory.create(pluginDir.getName(), DefaultCatalogPluginProvider.buildClassPath(pluginDir)));
                return null;
            });
        }
        DefaultCatalogPluginProvider.executeUntilFailure(this.executor, tasks);
    }

    private static List<URL> buildClassPath(File path) {
        return (List)DefaultCatalogPluginProvider.listFiles(path).stream().map(DefaultCatalogPluginProvider::fileToUrl).collect(ImmutableList.toImmutableList());
    }

    private static List<File> listFiles(File path) {
        List list;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path.toPath());
            try {
                list = (List)Streams.stream(directoryStream).map(Path::toFile).sorted().collect(ImmutableList.toImmutableList());
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T> void executeUntilFailure(Executor executor, Collection<Callable<T>> tasks) {
        ExecutorCompletionService<T> completionService = new ExecutorCompletionService<T>(executor);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            futures.add(completionService.submit(task));
        }
        try {
            for (int i = 0; i < futures.size(); ++i) {
                MoreFutures.getDone(DefaultCatalogPluginProvider.take(completionService));
            }
        }
        catch (Exception failure) {
            try {
                futures.forEach(future -> future.cancel(true));
            }
            catch (RuntimeException e) {
                failure.addSuppressed(e);
            }
            throw failure;
        }
    }

    private static <T> Future<T> take(CompletionService<T> completionService) {
        try {
            return completionService.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
    }
}

