/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.plugin;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import jakarta.annotation.PostConstruct;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import ru.cedrusdata.catalog.plugin.CatalogPluginClassLoader;
import ru.cedrusdata.catalog.plugin.CatalogPluginProvider;
import ru.cedrusdata.catalog.plugin.CatalogPluginRegistry;
import ru.cedrusdata.catalog.spi.CatalogPlugin;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemProvider;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;

public class CatalogPluginManager
implements CatalogPluginRegistry {
    private static final ImmutableList<String> SPI_PACKAGES = ImmutableList.builder().add((Object)"ru.cedrusdata.catalog.spi.").add((Object)"com.fasterxml.jackson.annotation.").add((Object)"io.opentelemetry.api.").add((Object)"io.opentelemetry.context.").build();
    private static final Logger log = Logger.get(CatalogPluginManager.class);
    private final CatalogPluginProvider pluginProvider;
    private final AtomicBoolean pluginsLoading = new AtomicBoolean();
    private final Map<CatalogFileSystemType, CatalogFileSystemProvider> catalogFileSystemProviders = new ConcurrentHashMap<CatalogFileSystemType, CatalogFileSystemProvider>();

    @Inject
    public CatalogPluginManager(CatalogPluginProvider pluginProvider) {
        this.pluginProvider = Objects.requireNonNull(pluginProvider, "pluginProvider");
    }

    @PostConstruct
    public void loadPlugins() {
        if (!this.pluginsLoading.compareAndSet(false, true)) {
            return;
        }
        this.pluginProvider.loadPlugins(this, this::loadPlugin, CatalogPluginManager::createClassLoader);
    }

    private void loadPlugin(String plugin, Supplier<CatalogPluginClassLoader> createClassLoader) {
        CatalogPluginClassLoader pluginClassLoader = createClassLoader.get();
        log.debug("Classpath for plugin:");
        for (URL url : pluginClassLoader.getURLs()) {
            log.debug("    %s", new Object[]{url.getPath()});
        }
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            this.loadPlugin(pluginClassLoader);
        }
    }

    private void loadPlugin(CatalogPluginClassLoader pluginClassLoader) {
        ServiceLoader<CatalogPlugin> serviceLoader = ServiceLoader.load(CatalogPlugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        for (CatalogPlugin plugin : plugins) {
            this.installPlugin(plugin);
        }
    }

    public void installPlugin(CatalogPlugin plugin) {
        for (CatalogFileSystemProvider catalogFileSystemProvider : plugin.getFileSystemProviders()) {
            this.addCatalogFileSystemProvider(catalogFileSystemProvider);
            log.info("Registered provider for %s file system", new Object[]{catalogFileSystemProvider.getFileSystemType().name()});
        }
    }

    private void addCatalogFileSystemProvider(CatalogFileSystemProvider provider) {
        CatalogFileSystemType type = provider.getFileSystemType();
        CatalogFileSystemProvider oldProvider = this.catalogFileSystemProviders.putIfAbsent(type, provider);
        if (oldProvider != null) {
            throw new CatalogInternalServerErrorException(String.format("Duplicate provider for %s file system: %s, %s", type.name(), oldProvider.getClass().getSimpleName(), provider.getClass().getSimpleName()));
        }
    }

    @Override
    public Optional<CatalogFileSystemProvider> getCatalogFileSystemProvider(CatalogFileSystemType type) {
        return Optional.ofNullable(this.catalogFileSystemProviders.get(type));
    }

    public static CatalogPluginClassLoader createClassLoader(String pluginName, List<URL> urls) {
        ClassLoader parent = CatalogPluginManager.class.getClassLoader();
        return new CatalogPluginClassLoader(pluginName, urls, parent, (List<String>)SPI_PACKAGES);
    }
}

