/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.jmx;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;
import ru.cedrusdata.catalog.spi.jmx.CatalogJmxNameCheck;

public final class CatalogJmxPrefixObjectNameGenerator
implements ObjectNameGenerator {
    private static final List<String> RESTRICTED_DOMAINS = List.of("io.trino");
    private static final String RESTRICTED_DOMAIN_PREFIX = "cedrusdata.catalog";
    private static final Map<String, String> DOMAIN_REMAPPING = Map.of("ru.cedrusdata.catalog", "cedrusdata.catalog");
    private final boolean strictNameCheck;

    @Inject
    public CatalogJmxPrefixObjectNameGenerator(CatalogJmxNameCheck nameCheck) {
        this.strictNameCheck = nameCheck.isStrictNameCheck();
    }

    public String generatedNameOf(Class<?> type, Map<String, String> properties) {
        Object domain = type.getPackage().getName();
        for (Map.Entry<String, String> entry : DOMAIN_REMAPPING.entrySet()) {
            String packagePrefix = entry.getKey();
            String replacement = entry.getValue();
            if (!((String)domain).startsWith(packagePrefix)) continue;
            domain = replacement + ((String)domain).substring(packagePrefix.length());
            break;
        }
        for (String restrictedDomain : RESTRICTED_DOMAINS) {
            if (!((String)domain).startsWith(restrictedDomain)) continue;
            if (this.strictNameCheck) {
                throw new IllegalStateException(String.format("Catalog JMX bean %s.%s is in restricted domain %s", domain, type.getName(), restrictedDomain));
            }
            domain = "cedrusdata.catalog." + (String)domain;
            break;
        }
        return new ObjectNameBuilder((String)domain).withProperties(properties).build();
    }
}

