/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.jmx;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jmx.StackTraceMBean;
import io.airlift.openmetrics.MetricsConfig;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.weakref.jmx.ObjectNameGenerator;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.jmx.CatalogJmxAgent;
import ru.cedrusdata.catalog.jmx.CatalogJmxPrefixObjectNameGenerator;
import ru.cedrusdata.catalog.jmx.OpenMetricsResource;
import ru.cedrusdata.catalog.spi.jmx.CatalogJmxNameCheck;

public class CatalogJmxModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.install((Module)new MBeanModule());
        CatalogConfig catalogConfig = (CatalogConfig)this.buildConfigObject(CatalogConfig.class);
        this.registerJmxCore(binder, catalogConfig);
        if (catalogConfig.isOpenmetricsEnabled()) {
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(OpenMetricsResource.class);
        }
        binder.bind(ObjectNameGenerator.class).to(CatalogJmxPrefixObjectNameGenerator.class);
    }

    @Provides
    @Singleton
    public CatalogJmxNameCheck getCatalogJmxRestrictedDomainBehavior(CatalogConfig config) {
        return new CatalogJmxNameCheck(config.isJmxStrictNameCheck());
    }

    @Provides
    @Singleton
    public MetricsConfig getMetricsConfig(CatalogConfig config) {
        return new MetricsConfig().setJmxObjectNames(config.getOpenmetricsJmxObjectNames());
    }

    protected void registerJmxCore(Binder binder, CatalogConfig config) {
        binder.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
        ExportBinder.newExporter((Binder)binder).export(StackTraceMBean.class).withGeneratedName();
        binder.bind(StackTraceMBean.class).in(Scopes.SINGLETON);
        binder.bind(CatalogJmxAgent.class).in(Scopes.SINGLETON);
    }
}

