/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table.internal;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.view.BaseViewOperations;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataUtils;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergInternalTableService;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectCommitFailedException;

public class IcebergViewOperations
extends BaseViewOperations {
    private final IcebergInternalTableService tableService;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final IcebergNamespaceContext namespaceContext;
    private final String viewName;
    private final FileIO io;

    public IcebergViewOperations(IcebergInternalTableService tableService, IcebergTableMetadataCache tableMetadataCache, IcebergNamespaceContext namespaceContext, String viewName, FileIO io) {
        this.tableService = tableService;
        this.tableMetadataCache = tableMetadataCache;
        this.namespaceContext = namespaceContext;
        this.viewName = viewName;
        this.io = io;
    }

    protected void doRefresh() {
        Optional<String> newMetadataLocation = this.tableService.currentMetadataLocation(this.namespaceContext, this.viewName, IcebergTableType.VIEW);
        if (newMetadataLocation.isEmpty()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchViewException("View does not exist: %s", new Object[]{TableIdentifier.of((String[])new String[]{this.namespaceContext.namespaceName(), this.viewName})});
            }
            this.disableRefresh();
        } else {
            this.refreshFromMetadataLocation(newMetadataLocation.get(), IcebergTableMetadataUtils::shouldRetryMetadataRead, 20, this::readMetadata);
        }
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        throw new UnsupportedOperationException("Should not be called");
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries) {
        throw new UnsupportedOperationException("Should not be called");
    }

    private ViewMetadata readMetadata(String metadataLocation) {
        return IcebergTableMetadataUtils.readMetadata(this.tableMetadataCache, this.namespaceContext, this.viewName, IcebergTableType.VIEW, this.io(), metadataLocation, ViewMetadataParser::fromJson);
    }

    protected void doCommit(ViewMetadata base, ViewMetadata metadata) {
        try {
            String newLocation = this.writeNewMetadataIfRequired(metadata);
            Optional<String> oldLocation = Optional.ofNullable(base == null ? null : base.metadataFileLocation());
            this.tableService.createOrUpdate(this.namespaceContext, this.viewName, IcebergTableType.VIEW, newLocation, oldLocation, Optional.empty());
        }
        catch (IcebergObjectAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage(), new Object[0]);
        }
        catch (IcebergObjectCommitFailedException e) {
            throw new CommitFailedException(e.getMessage(), new Object[0]);
        }
    }

    protected String viewName() {
        return this.namespaceContext.catalogName() + "." + this.namespaceContext.namespaceName() + "." + this.viewName;
    }

    protected FileIO io() {
        return this.io;
    }
}

