/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataUtils;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergInternalTableService;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergMaterializedViewSnapshotDetails;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectCommitFailedException;

public class IcebergTableOperations
extends BaseMetastoreTableOperations {
    private final IcebergInternalTableService tableService;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final IcebergNamespaceContext namespaceContext;
    private final String tableName;
    private final FileIO io;

    public IcebergTableOperations(IcebergInternalTableService tableService, IcebergTableMetadataCache tableMetadataCache, IcebergNamespaceContext namespaceContext, String tableName, FileIO io) {
        this.tableService = tableService;
        this.tableMetadataCache = tableMetadataCache;
        this.namespaceContext = namespaceContext;
        this.tableName = tableName;
        this.io = io;
    }

    protected void doRefresh() {
        Optional<String> newMetadataLocation = this.tableService.currentMetadataLocation(this.namespaceContext, this.tableName, IcebergTableType.TABLE);
        if (newMetadataLocation.isEmpty()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException("Table does not exist: %s", new Object[]{TableIdentifier.of((String[])new String[]{this.namespaceContext.namespaceName(), this.tableName})});
            }
            this.disableRefresh();
        } else {
            this.refreshFromMetadataLocation(newMetadataLocation.get(), IcebergTableMetadataUtils::shouldRetryMetadataRead, 20, this::readMetadata);
        }
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        throw new UnsupportedOperationException("Should not be called");
    }

    protected void refreshFromMetadataLocation(String newLocation, int numRetries) {
        throw new UnsupportedOperationException("Should not be called");
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries) {
        throw new UnsupportedOperationException("Should not be called");
    }

    private TableMetadata readMetadata(String metadataLocation) {
        return IcebergTableMetadataUtils.readMetadata(this.tableMetadataCache, this.namespaceContext, this.tableName, IcebergTableType.TABLE, this.io(), metadataLocation, TableMetadataParser::fromJson);
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        try {
            String newLocation = this.writeNewMetadataIfRequired(base == null, metadata);
            Optional<String> oldLocation = Optional.ofNullable(base == null ? null : base.metadataFileLocation());
            Optional<IcebergMaterializedViewDetails> materializedViewDetails = IcebergTableOperations.extractMaterializedViewDetails(metadata);
            this.tableService.createOrUpdate(this.namespaceContext, this.tableName, IcebergTableType.TABLE, newLocation, oldLocation, materializedViewDetails);
        }
        catch (IcebergObjectAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage(), new Object[0]);
        }
        catch (IcebergObjectCommitFailedException e) {
            throw new CommitFailedException(e.getMessage(), new Object[0]);
        }
    }

    private static Optional<IcebergMaterializedViewDetails> extractMaterializedViewDetails(TableMetadata metadata) {
        Optional<IcebergMaterializedViewDetails> materializedViewDetails = Optional.empty();
        if (metadata.properties().containsKey("cedrusdata-mv-definition")) {
            String plan;
            Optional<IcebergMaterializedViewSnapshotDetails> materializedViewSnapshotDetails = Optional.empty();
            Snapshot snapshot = metadata.currentSnapshot();
            if (snapshot != null && (plan = (String)snapshot.summary().get("cedrusdata-mv-rewrite-plan")) != null) {
                HashSet<String> referencedTables = new HashSet<String>();
                String referencedTablesStr = (String)snapshot.summary().get("cedrusdata-mv-rewrite-referenced-tables");
                if (referencedTablesStr != null) {
                    referencedTables.addAll(Arrays.asList(referencedTablesStr.split(",")));
                }
                materializedViewSnapshotDetails = Optional.of(new IcebergMaterializedViewSnapshotDetails(snapshot.snapshotId(), plan, referencedTables));
            }
            materializedViewDetails = Optional.of(new IcebergMaterializedViewDetails(materializedViewSnapshotDetails));
        }
        return materializedViewDetails;
    }

    protected String tableName() {
        return this.namespaceContext.catalogName() + "." + this.namespaceContext.namespaceName() + "." + this.tableName;
    }

    public FileIO io() {
        return this.io;
    }
}

