/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table.internal;

import com.google.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableKey;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergCatalog;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.spi.CatalogObjectType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectCommitFailedException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectDoesNotExistException;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.store.CatalogStore;

public class IcebergInternalTableService {
    private final CatalogStore catalogStore;
    private final IcebergTableMetadataCache tableMetadataCache;

    @Inject
    public IcebergInternalTableService(IcebergTableMetadataCache tableMetadataCache, CatalogStore catalogStore) {
        this.tableMetadataCache = Objects.requireNonNull(tableMetadataCache, "tableMetadataCache");
        this.catalogStore = Objects.requireNonNull(catalogStore, "catalogStore");
    }

    public IcebergObjectInfo getObjectForApi(String catalogName, String namespaceName, String objectName) {
        return this.catalogStore.getIcebergObjectForApi(catalogName, namespaceName, objectName).orElseThrow(() -> new IcebergObjectDoesNotExistException(namespaceName, objectName, Optional.empty()));
    }

    public IcebergObjectListResponse listObjectsForApi(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        return this.catalogStore.listIcebergObjectsForApi(catalogName, namespaceName, objectType, page);
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewriteForApi(String catalogName, Set<String> tableNames) {
        return this.catalogStore.listIcebergMaterializedViewsForRewriteForApi(catalogName, tableNames);
    }

    public IcebergCatalog asCatalog(IcebergNamespaceContext namespaceContext) {
        return new IcebergCatalog(this, this.tableMetadataCache, namespaceContext);
    }

    public void createOrUpdate(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type, String metadataLocation, Optional<String> oldMetadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails) {
        if (oldMetadataLocation.isEmpty()) {
            this.create(namespaceContext, name, type, metadataLocation, materializedViewDetails);
        } else {
            this.update(namespaceContext, name, type, metadataLocation, oldMetadataLocation.get(), materializedViewDetails);
        }
    }

    private void create(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type, String metadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails) {
        boolean created = this.catalogStore.createIcebergTableIfNotExist(namespaceContext.namespaceId(), name, type, metadataLocation, materializedViewDetails);
        if (!created) {
            throw new IcebergObjectAlreadyExistsException(namespaceContext.namespaceName(), name);
        }
    }

    private void update(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type, String metadataLocation, String oldMetadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails) {
        boolean updated = this.catalogStore.updateIcebergTableIfExists(namespaceContext.namespaceId(), name, type, metadataLocation, oldMetadataLocation, materializedViewDetails);
        if (!updated) {
            throw new IcebergObjectCommitFailedException(namespaceContext.namespaceName(), name);
        }
        this.invalidateCache(namespaceContext, name, type);
    }

    public boolean rename(String catalogName, IcebergNamespaceContext sourceNamespaceContext, String sourceName, IcebergNamespaceContext destinationNamespaceContext, String destinationName, IcebergTableType type) {
        boolean renamed = this.catalogStore.renameIcebergTableIfExists(catalogName, sourceNamespaceContext.namespaceId(), sourceName, destinationNamespaceContext.namespaceName(), destinationNamespaceContext.namespaceId(), destinationName, type);
        if (renamed) {
            this.invalidateCache(sourceNamespaceContext, sourceName, type);
        }
        return renamed;
    }

    public boolean delete(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        String normalizedName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, name);
        boolean deleted = this.catalogStore.deleteIcebergTableIfExists(namespaceContext.namespaceId(), normalizedName, type);
        if (deleted) {
            this.invalidateCache(namespaceContext, normalizedName, type);
        }
        return deleted;
    }

    public ListTablesResponse list(IcebergNamespaceContext namespaceContext, IcebergTableType type, ResultPage page) {
        IcebergTableListResult result = this.catalogStore.listIcebergTables(namespaceContext.namespaceId(), type, page);
        ListTablesResponse.Builder builder = ListTablesResponse.builder();
        for (String tableName : result.tableNames()) {
            builder.add(TableIdentifier.of((String[])new String[]{namespaceContext.namespaceName(), tableName}));
        }
        builder.nextPageToken(result.token());
        return builder.build();
    }

    public Optional<String> currentMetadataLocation(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        if (this.tableMetadataCache.enabled()) {
            String cacheKey = IcebergInternalTableService.createCacheKey(namespaceContext, name, type);
            Optional<String> res = Optional.ofNullable(this.tableMetadataCache.getMetadataLocation(cacheKey));
            if (res.isEmpty() && (res = this.catalogStore.getIcebergTableMetadataLocation(namespaceContext.catalogName(), namespaceContext.namespaceName(), namespaceContext.namespaceId(), name, type)).isPresent()) {
                this.tableMetadataCache.putMetadataLocation(cacheKey, res.get());
            }
            return res;
        }
        return this.catalogStore.getIcebergTableMetadataLocation(namespaceContext.catalogName(), namespaceContext.namespaceName(), namespaceContext.namespaceId(), name, type);
    }

    private void invalidateCache(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        if (this.tableMetadataCache.enabled()) {
            String cacheKey = IcebergInternalTableService.createCacheKey(namespaceContext, name, type);
            this.tableMetadataCache.invalidate(cacheKey);
        }
    }

    private static String createCacheKey(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        return IcebergTableMetadataCache.createMetadataLocationKey(new IcebergTableKey(namespaceContext.catalogId(), namespaceContext.namespaceId(), name, type));
    }
}

