/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table.internal;

import io.airlift.log.Logger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.view.BaseMetastoreViewCatalog;
import org.apache.iceberg.view.ViewOperations;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergInternalTableService;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergTableOperations;
import ru.cedrusdata.catalog.iceberg.table.internal.IcebergViewOperations;
import ru.cedrusdata.catalog.spi.CatalogObjectType;

public class IcebergCatalog
extends BaseMetastoreViewCatalog {
    private static final Logger logger = Logger.get(IcebergCatalog.class);
    private final IcebergInternalTableService tableService;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final IcebergNamespaceContext namespaceContext;

    public IcebergCatalog(IcebergInternalTableService tableService, IcebergTableMetadataCache tableMetadataCache, IcebergNamespaceContext namespaceContext) {
        this.tableService = tableService;
        this.tableMetadataCache = tableMetadataCache;
        this.namespaceContext = namespaceContext;
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        return new IcebergTableOperations(this.tableService, this.tableMetadataCache, this.namespaceContext, CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableIdentifier.name()), this.namespaceContext.icebergCatalogContext().ioFactory().createFileIO(this.namespaceContext.icebergCatalogContext().currentPrincipal()));
    }

    protected ViewOperations newViewOps(TableIdentifier viewIdentifier) {
        return new IcebergViewOperations(this.tableService, this.tableMetadataCache, this.namespaceContext, CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, viewIdentifier.name()), this.namespaceContext.icebergCatalogContext().ioFactory().createFileIO(this.namespaceContext.icebergCatalogContext().currentPrincipal()));
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        String normalizedNamespaceName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_NAMESPACE, tableIdentifier.namespace().level(0));
        String normalizedTableName = CatalogUtils.normalizeObjectName(CatalogObjectType.ICEBERG_TABLE_OR_VIEW, tableIdentifier.name());
        return this.namespaceContext.icebergCatalogContext().catalogInfo().resolveFileSystemLocationSuffix(normalizedNamespaceName, normalizedTableName);
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        throw new UnsupportedOperationException("listTables should not be called");
    }

    public List<TableIdentifier> listViews(Namespace namespace) {
        throw new UnsupportedOperationException("listViews should not be called");
    }

    public boolean dropTable(TableIdentifier tableIdentifier, boolean purge) {
        boolean deleted;
        TableOperations ops = this.newTableOps(tableIdentifier);
        TableMetadata lastMetadata = null;
        if (purge) {
            try {
                lastMetadata = ops.current();
            }
            catch (NotFoundException e) {
                logger.warn((Throwable)e, String.format("Failed to load table \"%s\" metadata, continuing drop without purge", tableIdentifier));
            }
        }
        if (!(deleted = this.tableService.delete(this.namespaceContext, tableIdentifier.name(), IcebergTableType.TABLE))) {
            return false;
        }
        if (purge && lastMetadata != null) {
            try {
                CatalogUtil.dropTableData((FileIO)this.namespaceContext.icebergCatalogContext().ioFactory().createFileIO(this.namespaceContext.icebergCatalogContext().currentPrincipal()), (TableMetadata)lastMetadata);
            }
            catch (Exception e) {
                logger.warn((Throwable)e, String.format("Failed to delete table \"%s\" data: " + e.getMessage(), tableIdentifier));
            }
        }
        return true;
    }

    public boolean dropView(TableIdentifier viewIdentifier) {
        return this.tableService.delete(this.namespaceContext, viewIdentifier.name(), IcebergTableType.VIEW);
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        throw new UnsupportedOperationException("renameTable should not be called");
    }

    public void renameView(TableIdentifier from, TableIdentifier to) {
        throw new UnsupportedOperationException("renameView should not be called");
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

